/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentials;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.AltusCredentialsProvider;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication.credentials.profile.AltusProfileConfigFile;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.javax.annotation.Nullable;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.apache.commons.lang3.StringUtils;

public class AltusProfileCredentialsProvider
implements AltusCredentialsProvider {
    public static final String ALTUS_DEFAULT_PROFILE = "ALTUS_DEFAULT_PROFILE";
    public static final String ALTUS_DEFAULT_PROFILE_NAME = "default";
    private volatile AltusProfileConfigFile altusProfileConfigFile;
    private final String altusProfileName;

    public AltusProfileCredentialsProvider() {
        this(null);
    }

    public AltusProfileCredentialsProvider(@Nullable String profileName) {
        this((AltusProfileConfigFile)null, profileName);
    }

    public AltusProfileCredentialsProvider(String profileFilePath, @Nullable String profileName) {
        this(new AltusProfileConfigFile(ValidationUtils.checkNotNullAndThrow(profileFilePath)), profileName);
    }

    private AltusProfileCredentialsProvider(@Nullable AltusProfileConfigFile profilesConfigFile, @Nullable String profileName) {
        this.altusProfileConfigFile = profilesConfigFile;
        this.altusProfileName = StringUtils.isBlank(profileName) ? this.getAltusProfileName() : profileName;
    }

    private String getAltusProfileName() {
        String envProfileName = System.getenv(ALTUS_DEFAULT_PROFILE);
        if (StringUtils.isBlank(envProfileName)) {
            return ALTUS_DEFAULT_PROFILE_NAME;
        }
        return envProfileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AltusCredentials getCredentials() {
        if (this.altusProfileConfigFile == null) {
            AltusProfileCredentialsProvider altusProfileCredentialsProvider = this;
            synchronized (altusProfileCredentialsProvider) {
                if (this.altusProfileConfigFile == null) {
                    this.altusProfileConfigFile = new AltusProfileConfigFile();
                }
            }
        }
        return this.altusProfileConfigFile.getCredentials(this.altusProfileName);
    }
}

