/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus.authentication;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.ValidationUtils;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.collect.Maps;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.org.apache.commons.codec.binary.Base64;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.TreeMap;

public class Signer {
    private static final String RSA_AUTH_METHOD = "rsav1";
    private static final String RSA_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String ED25519_AUTH_METHOD = "ed25519v1";

    public String computeAuthHeader(String httpMethod, String contentType, String date, String path, String accessKeyId, PrivateKey privateKey) {
        String signatureString;
        String sigAlgo;
        String authMethod;
        ValidationUtils.checkNotNullAndThrow(httpMethod);
        ValidationUtils.checkNotNullAndThrow(contentType);
        ValidationUtils.checkNotNullAndThrow(date);
        ValidationUtils.checkNotNullAndThrow(path);
        ValidationUtils.checkNotNullAndThrow(accessKeyId);
        ValidationUtils.checkNotNullAndThrow(privateKey);
        switch (privateKey.getAlgorithm()) {
            case "RSA": {
                authMethod = RSA_AUTH_METHOD;
                sigAlgo = RSA_SIGNATURE_ALGORITHM;
                break;
            }
            case "EdDSA": {
                authMethod = ED25519_AUTH_METHOD;
                sigAlgo = "NONEwithEdDSA";
                break;
            }
            default: {
                throw new AltusClientException("Unsupported Key Algorithm: " + privateKey.getAlgorithm());
            }
        }
        String stringToSign = httpMethod + "\n" + contentType + "\n" + date + "\n" + path + "\n" + authMethod;
        try {
            Signature signature = Signature.getInstance(sigAlgo);
            signature.initSign(privateKey);
            signature.update(stringToSign.getBytes(StandardCharsets.UTF_8));
            signatureString = Base64.encodeBase64URLSafeString(signature.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
        try {
            TreeMap<String, String> authParams = Maps.newTreeMap();
            authParams.put("access_key_id", accessKeyId);
            authParams.put("auth_method", authMethod);
            String encodedAuthParams = new ObjectMapper().writeValueAsString(authParams);
            return String.format("%s.%s", Base64.encodeBase64URLSafeString(encodedAuthParams.getBytes(StandardCharsets.UTF_8)), signatureString);
        }
        catch (JsonProcessingException e) {
            throw new AltusClientException("Error while building authentication header");
        }
    }
}

