/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.com.cloudera.altus;

import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.AltusClientException;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.annotation.SdkInternalApi;
import com.cloudera.impala.jdbc42.internal.com.cloudera.altus.shaded.com.google.common.base.Preconditions;

@SdkInternalApi
public class ValidationUtils {
    private ValidationUtils() {
    }

    public static void checkStateAndThrow(boolean expr) {
        try {
            Preconditions.checkState(expr);
        }
        catch (IllegalStateException e) {
            throw new AltusClientException("Illegal state");
        }
    }

    public static void checkArgumentAndThrow(boolean expr) {
        try {
            Preconditions.checkArgument(expr);
        }
        catch (IllegalArgumentException e) {
            throw new AltusClientException("Illegal argument");
        }
    }

    public static <T> T checkNotNullAndThrow(T ref) {
        try {
            return Preconditions.checkNotNull(ref);
        }
        catch (NullPointerException e) {
            throw new AltusClientException("Argument is null");
        }
    }
}

