/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum;

import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.FinalRequestProcessor;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.Request;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.SyncRequestProcessor;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.ZKDatabase;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.ZooKeeperServer;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.persistence.FileTxnSnapLog;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.CommitProcessor;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.Learner;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.Observer;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.ObserverRequestProcessor;
import com.cloudera.impala.jdbc42.internal.apache.zookeeper.server.quorum.QuorumPeer;
import com.cloudera.impala.jdbc42.internal.slf4j.Logger;
import com.cloudera.impala.jdbc42.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObserverZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverZooKeeperServer.class);
    private boolean syncRequestProcessorEnabled;
    private CommitProcessor commitProcessor;
    private SyncRequestProcessor syncProcessor;
    ConcurrentLinkedQueue<Request> pendingSyncs;

    ObserverZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
        this.syncRequestProcessorEnabled = this.self.getSyncEnabled();
        this.pendingSyncs = new ConcurrentLinkedQueue();
        LOG.info("syncEnabled =" + this.syncRequestProcessorEnabled);
    }

    public Observer getObserver() {
        return this.self.observer;
    }

    @Override
    public Learner getLearner() {
        return this.self.observer;
    }

    public void commitRequest(Request request) {
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor.processRequest(request);
        }
        this.commitProcessor.commit(request);
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        this.firstProcessor = new ObserverRequestProcessor(this, this.commitProcessor);
        ((ObserverRequestProcessor)this.firstProcessor).start();
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor = new SyncRequestProcessor(this, null);
            this.syncProcessor.start();
        }
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    @Override
    public String getState() {
        return "observer";
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        super.shutdown();
        if (this.syncRequestProcessorEnabled && this.syncProcessor != null) {
            this.syncProcessor.shutdown();
        }
    }
}

