/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.apache.thrift.transport;

import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.AutoExpandingBuffer;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;

public final class AutoExpandingBufferWriteTransport
extends TTransport {
    private final AutoExpandingBuffer buf;
    private int pos;

    public AutoExpandingBufferWriteTransport(int initialCapacity, double growthCoefficient) {
        this.buf = new AutoExpandingBuffer(initialCapacity, growthCoefficient);
        this.pos = 0;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() throws TTransportException {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] toWrite, int off, int len) throws TTransportException {
        this.buf.resizeIfNecessary(this.pos + len);
        System.arraycopy(toWrite, off, this.buf.array(), this.pos, len);
        this.pos += len;
    }

    public AutoExpandingBuffer getBuf() {
        return this.buf;
    }

    public int getPos() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }
}

