/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.rpc;

import com.cloudera.impala.jdbc.http.extention.ExtendedPlainConnectionSocketFactory;
import com.cloudera.impala.jdbc.http.extention.ExtentedSSLConnectionSocketFactory;
import com.cloudera.impala.jdbc42.internal.apache.http.config.Registry;
import com.cloudera.impala.jdbc42.internal.apache.http.config.RegistryBuilder;
import com.cloudera.impala.jdbc42.internal.apache.http.conn.DnsResolver;
import com.cloudera.impala.jdbc42.internal.apache.http.conn.socket.ConnectionSocketFactory;
import com.cloudera.impala.jdbc42.internal.apache.http.conn.ssl.NoopHostnameVerifier;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.client.HttpClients;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.conn.BasicHttpClientConnectionManager;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.conn.DefaultSchemePortResolver;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public class HttpClientFactory {
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";

    public static HttpClientBuilder createHttpsClient(SocketFactory socketFactory, SSLContext sSLContext, DnsResolver dnsResolver, boolean bl, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, socketFactory, sSLContext, dnsResolver, bl);
        if (null == socketFactory) {
            socketFactory = sSLContext.getSocketFactory();
        }
        ExtentedSSLConnectionSocketFactory extentedSSLConnectionSocketFactory = bl ? new ExtentedSSLConnectionSocketFactory(sSLContext, NoopHostnameVerifier.INSTANCE, socketFactory, iLogger) : new ExtentedSSLConnectionSocketFactory(sSLContext, socketFactory, iLogger);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register(HTTPS_SCHEME, extentedSSLConnectionSocketFactory).build();
        BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager(registry, ManagedHttpClientConnectionFactory.INSTANCE, DefaultSchemePortResolver.INSTANCE, dnsResolver);
        return HttpClientBuilder.create().setConnectionManager(basicHttpClientConnectionManager).setSSLSocketFactory(extentedSSLConnectionSocketFactory);
    }

    public static HttpClientBuilder createHttpClient(SocketFactory socketFactory, DnsResolver dnsResolver, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, socketFactory, dnsResolver);
        if (null == socketFactory) {
            socketFactory = SocketFactory.getDefault();
        }
        ExtendedPlainConnectionSocketFactory extendedPlainConnectionSocketFactory = new ExtendedPlainConnectionSocketFactory(socketFactory, iLogger);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register(HTTP_SCHEME, extendedPlainConnectionSocketFactory).build();
        BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager(registry, ManagedHttpClientConnectionFactory.INSTANCE, DefaultSchemePortResolver.INSTANCE, dnsResolver);
        return HttpClients.custom().setConnectionManager(basicHttpClientConnectionManager);
    }
}

