/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.jdbc41;

import com.cloudera.impala.dsi.dataengine.interfaces.IArray;
import com.cloudera.impala.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.jdbc.common.SArray;
import com.cloudera.impala.jdbc.common.SForwardResultSet;
import com.cloudera.impala.jdbc.common.SStatement;
import com.cloudera.impala.jdbc.jdbc41.S41Array;
import com.cloudera.impala.jdbc.jdbc41.S41ResultSetMetaData;
import com.cloudera.impala.jdbc.jdbc41.utilities.ResultSetUtilities;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.utilities.JDBCVersion;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S41ForwardResultSet
extends SForwardResultSet {
    public S41ForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S41ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clazz);
            this.checkIfOpen();
            return ResultSetUtilities.getObjectByType(this, n, clazz);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clazz);
        return this.getObject(this.findColumn(string), clazz);
    }

    @Override
    protected SArray createArrayResult(IArray iArray) throws SQLException {
        return new S41Array(iArray, this.getParentConnection(), this.getLogger(), this.getWarningListener());
    }
}

