/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.common;

import com.cloudera.impala.dsi.core.impl.DSIDriverFactory;
import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.core.interfaces.IConnection;
import com.cloudera.impala.dsi.core.interfaces.IDriver;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.ConnSettingResponseMap;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.exceptions.JDBCMessageKey;
import com.cloudera.impala.jdbc.common.BaseConnectionFactory;
import com.cloudera.impala.jdbc.common.JDBCObjectFactory;
import com.cloudera.impala.jdbc.common.SWarningListener;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Pair;
import com.cloudera.impala.support.SettingReader;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.ExceptionType;
import com.cloudera.impala.utilities.FunctionID;
import com.cloudera.impala.utilities.PropertyTypeConverter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class AbstractDriver
extends BaseConnectionFactory
implements Driver {
    private static final String VERSION_SEPARATOR = ".";
    public static final String URL_PROTOCOL = "jdbc";
    protected static boolean s_isInitialized = false;
    private static String s_messageComponentName = "[JDBC Driver]";
    private SWarningListener m_warningListener;

    public static String getErrorMessageComponentName() {
        return s_messageComponentName;
    }

    public static void initialize(AbstractDriver abstractDriver, String string) throws SQLException {
        DSIDriverFactory.setDriverClassName(string);
        try {
            abstractDriver.initializeDriver();
        }
        catch (SQLException sQLException) {
            ExceptionConverter.getInstance().toSQLException("HY000", "A database access error occurred while registering the driver", 0, ExceptionType.DEFAULT);
        }
    }

    public void initializeDriver() throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException("HY000", "A database access error occurred while registering the driver", 0, ExceptionType.DEFAULT);
    }

    public static void setErrorMessageComponentName(String string) {
        s_messageComponentName = "[" + string + "]";
    }

    public AbstractDriver() {
        SettingReader.loadSimbaSettings();
    }

    @Override
    public final boolean acceptsURL(String string) {
        return this.acceptsURL(string, new Properties());
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        if (null != properties) {
            this.copyProperties(properties2, properties);
        }
        this.doInitialize();
        if (!this.acceptsURL(string, properties2)) {
            return null;
        }
        Pair<IConnection, ConnSettingRequestMap> pair = this.getConnection(properties2);
        return this.doConnect(pair, string);
    }

    @Override
    public int getMajorVersion() {
        int n = 1;
        try {
            this.doInitialize();
            IDriver iDriver = DSIDriverSingleton.getInstance();
            Variant variant = iDriver.getProperty(5);
            if (null == variant.getString()) {
                ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_VERSION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, variant.getString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(variant.getString(), VERSION_SEPARATOR);
            String string = stringTokenizer.nextToken();
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    @Override
    public int getMinorVersion() {
        int n = 0;
        try {
            this.doInitialize();
            IDriver iDriver = DSIDriverSingleton.getInstance();
            Variant variant = iDriver.getProperty(5);
            if (null == variant.getString()) {
                ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_VERSION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, variant.getString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(variant.getString(), VERSION_SEPARATOR);
            stringTokenizer.nextToken();
            String string = stringTokenizer.nextToken();
            n = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        if (null != properties) {
            this.copyProperties(properties2, properties);
        }
        this.doInitialize();
        if (!this.acceptsURL(string, properties2)) {
            ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_URL, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
        try {
            Pair<IConnection, ConnSettingRequestMap> pair = this.getConnection(properties2);
            IConnection iConnection = pair.key();
            IWarningListener iWarningListener = iConnection.getWarningListener();
            ConnSettingResponseMap connSettingResponseMap = null;
            if (null == iWarningListener) {
                iWarningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
                iConnection.registerWarningListener(iWarningListener);
            }
            connSettingResponseMap = iConnection.updateConnectionSettings(pair.value());
            for (Warning warning : iWarningListener.getWarnings()) {
                LogUtilities.logWarning(warning.getMessage(), DSIDriverSingleton.getInstance().getDriverLog());
            }
            iConnection.disconnect();
            iConnection.close();
            SettingReader.clearAllSettings();
            return PropertyTypeConverter.toDriverPropertyInfo(connSettingResponseMap);
        }
        catch (Exception exception) {
            SettingReader.clearAllSettings();
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    protected abstract JDBCObjectFactory createJDBCObjectFactory();

    private void copyProperties(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, properties2.get(string));
        }
    }

    private void doInitialize() throws SQLException {
        if (!s_isInitialized) {
            ExceptionConverter.getInstance().toSQLException("HY000", "Class has not been initialized.Please initialize by calling AbstractDriver.initialize()", 0, ExceptionType.DEFAULT);
        } else if (null == DSIDriverSingleton.getInstance()) {
            try {
                IDriver iDriver = DSIDriverFactory.createDriver();
                DSIDriverSingleton.setInstance(iDriver);
                this.m_warningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), FunctionID.BEFORE_CONNECTION);
                ILogger iLogger = iDriver.getDriverLog();
                try {
                    Variant variant = iDriver.getProperty(5);
                    LogUtilities.logInfo("Driver version is: " + variant.getString(), iLogger);
                }
                catch (ErrorException errorException) {
                    LogUtilities.logInfo("Wasn't able to retrieve the driver version.", iLogger);
                    LogUtilities.logInfo(errorException, iLogger);
                }
            }
            catch (ErrorException errorException) {
                SQLException sQLException = new SQLException(errorException.getLocalizedMessage());
                sQLException.initCause(errorException);
                throw sQLException;
            }
        }
    }
}

