/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.impala.querytranslation;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.IServerVersion;
import com.cloudera.impala.hivecommon.IServerVersionUtils;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.querytranslation.IQueryTranslator;
import com.cloudera.impala.impala.querytranslation.ImpalaQLAENodeVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;

public class ImpalaQueryTranslator
implements IQueryTranslator {
    private ArrayList<IColumn> m_selectColumnRef;

    @Override
    public String translate(AEStatements aEStatements, ExecutionContexts executionContexts, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        Iterator<IAEStatement> iterator = aEStatements.getStatementItr();
        if (!iterator.hasNext()) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_STATEMENT_ERR.name());
        }
        return this.translate(iterator.next(), executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion);
    }

    @Override
    public ArrayList<IColumn> getSelectColumns() {
        return this.m_selectColumnRef;
    }

    private String translate(IAEStatement iAEStatement, ExecutionContexts executionContexts, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion) throws ErrorException {
        if (iAEStatement instanceof AEQuery) {
            AEQuery aEQuery = (AEQuery)iAEStatement;
            ImpalaQLAENodeVisitor impalaQLAENodeVisitor = new ImpalaQLAENodeVisitor(executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion);
            String string = aEQuery.acceptVisitor(impalaQLAENodeVisitor);
            this.m_selectColumnRef = ((AEQuery)iAEStatement).createResultSetColumns();
            CoreUtils.removeComplexColumns(this.m_selectColumnRef);
            return string;
        }
        if (iAEStatement instanceof AEInsert) {
            AEInsert aEInsert = (AEInsert)iAEStatement;
            ImpalaQLAENodeVisitor impalaQLAENodeVisitor = new ImpalaQLAENodeVisitor(executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion);
            String string = aEInsert.acceptVisitor(impalaQLAENodeVisitor);
            return string;
        }
        if (iAEStatement instanceof AEUpdate) {
            AEUpdate aEUpdate = (AEUpdate)iAEStatement;
            ImpalaQLAENodeVisitor impalaQLAENodeVisitor = new ImpalaQLAENodeVisitor(executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion);
            String string = aEUpdate.acceptVisitor(impalaQLAENodeVisitor);
            return string;
        }
        if (iAEStatement instanceof AEDelete) {
            AEDelete aEDelete = (AEDelete)iAEStatement;
            ImpalaQLAENodeVisitor impalaQLAENodeVisitor = new ImpalaQLAENodeVisitor(executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion);
            String string = aEDelete.acceptVisitor(impalaQLAENodeVisitor);
            return string;
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_STATEMENT_ERR.name());
    }
}

