/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.querytranslation.hql;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.IServerVersion;
import com.cloudera.impala.hivecommon.IServerVersionUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.querytranslation.IQueryTranslator;
import com.cloudera.impala.hivecommon.querytranslation.hql.HiveQLAENodeVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;

public class HiveQueryTranslator
implements IQueryTranslator {
    private ArrayList<IColumn> m_selectColumnRef;
    protected HiveJDBCSettings m_settings;

    @Override
    public String translate(AEStatements aEStatements, ExecutionContexts executionContexts, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        this.m_settings = hiveJDBCSettings;
        Iterator<IAEStatement> iterator = aEStatements.getStatementItr();
        if (!iterator.hasNext()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), "translation error");
            throw errorException;
        }
        return this.translate(iterator.next(), executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion);
    }

    public String translate(IAEStatement iAEStatement, ExecutionContexts executionContexts, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion) throws ErrorException {
        String string;
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        if (!iterator.hasNext()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), "translation error");
            throw errorException;
        }
        if (iAEStatement instanceof AEQuery) {
            AEQuery aEQuery = (AEQuery)iAEStatement;
            HiveQLAENodeVisitor hiveQLAENodeVisitor = new HiveQLAENodeVisitor(iterator.next(), sqlQueryExecutor, iServerVersionUtils, iServerVersion, this.m_settings);
            string = aEQuery.acceptVisitor(hiveQLAENodeVisitor);
            this.m_selectColumnRef = ((AEQuery)iAEStatement).createResultSetColumns();
        } else if (iAEStatement instanceof AEInsert) {
            AEInsert aEInsert = (AEInsert)iAEStatement;
            HiveQLAENodeVisitor hiveQLAENodeVisitor = executionContexts.getCount() > 1 && iServerVersionUtils.supportsDMLstatement(iServerVersion) ? new HiveQLAENodeVisitor(executionContexts, sqlQueryExecutor, iServerVersionUtils, iServerVersion) : new HiveQLAENodeVisitor(iterator.next(), sqlQueryExecutor, iServerVersionUtils, iServerVersion, this.m_settings);
            string = aEInsert.acceptVisitor(hiveQLAENodeVisitor);
        } else if (iAEStatement instanceof AEDelete && iServerVersionUtils.supportsDMLstatement(iServerVersion)) {
            AEDelete aEDelete = (AEDelete)iAEStatement;
            HiveQLAENodeVisitor hiveQLAENodeVisitor = new HiveQLAENodeVisitor(iterator.next(), sqlQueryExecutor, iServerVersionUtils, iServerVersion, this.m_settings);
            string = aEDelete.acceptVisitor(hiveQLAENodeVisitor);
        } else if (iAEStatement instanceof AEUpdate && iServerVersionUtils.supportsDMLstatement(iServerVersion)) {
            AEUpdate aEUpdate = (AEUpdate)iAEStatement;
            HiveQLAENodeVisitor hiveQLAENodeVisitor = new HiveQLAENodeVisitor(iterator.next(), sqlQueryExecutor, iServerVersionUtils, iServerVersion, this.m_settings);
            string = aEUpdate.acceptVisitor(hiveQLAENodeVisitor);
        } else {
            throw new ErrorException("error", "Statement type is not supported.", 0);
        }
        return string;
    }

    @Override
    public ArrayList<IColumn> getSelectColumns() {
        return this.m_selectColumnRef;
    }
}

