/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine.metadata;

import com.cloudera.impala.dsi.dataengine.filters.IFilter;
import com.cloudera.impala.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.impala.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.dataengine.utilities.Nullable;
import com.cloudera.impala.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.cloudera.impala.hivecommon.dataengine.metadata.MetadataUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Map;

public class HiveJDBCColumnsMetadataSource
implements IMetadataSource {
    private HiveJDBCSettings m_settings;
    private boolean m_hasStartedFetch = false;
    private int m_currentIndex = -1;
    private int m_currentColumn = 0;
    private String m_currentSchema;
    private String m_currentTable;
    private ILogger m_logger;
    private final IHiveClient m_hiveClient;
    private Map<MetadataSourceColumnTag, String> m_literalRestrictions = null;
    private ArrayList<String> m_restrictionPatterns = null;
    private ArrayList<IFilter> m_filters = null;
    private ArrayList<HiveCommonColumnMetadata> m_columns = null;
    private ArrayList<String> m_schemas = null;

    public HiveJDBCColumnsMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, ArrayList<IFilter> arrayList2, IHiveClient iHiveClient, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_hiveClient = iHiveClient;
        this.m_literalRestrictions = map;
        this.m_restrictionPatterns = arrayList;
        this.m_filters = arrayList2;
        this.m_settings = hiveJDBCSettings;
        this.initializeColumn();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get(this.m_currentIndex).getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get(this.m_currentIndex).getSchemaName(), dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get(this.m_currentIndex).getTableName(), dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get(this.m_currentIndex).getName(), dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(this.m_columns.get(this.m_currentIndex).getTypeMetadata().getType());
                return false;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get(this.m_currentIndex).getTypeMetadata().getTypeName(), dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(this.m_columns.get(this.m_currentIndex).getColumnLength());
                return false;
            }
            case BUFFER_LENGTH: {
                dataWrapper.setSmallInt(MetadataUtils.getBufferSize(this.m_columns.get(this.m_currentIndex), this.m_hiveClient));
                return false;
            }
            case DECIMAL_DIGITS: {
                dataWrapper.setSmallInt(this.m_columns.get(this.m_currentIndex).getTypeMetadata().getScale());
                return false;
            }
            case NUM_PREC_RADIX: {
                dataWrapper.setSmallInt(MetadataUtils.getNumPrecRadix(this.m_columns.get(this.m_currentIndex).getTypeMetadata()));
                return false;
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(this.m_columns.get(this.m_currentIndex).getNullable().ordinal());
                return false;
            }
            case REMARKS: {
                DSITypeUtilities.outputVarCharStringData(this.m_columns.get(this.m_currentIndex).getComment(), dataWrapper, l, l2);
                return false;
            }
            case COLUMN_DEF: {
                dataWrapper.setNull(this.m_columns.get(this.m_currentIndex).getTypeMetadata().getType());
                return false;
            }
            case SQL_DATA_TYPE: {
                short s = this.m_columns.get(this.m_currentIndex).getTypeMetadata().getType();
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(s));
                return false;
            }
            case SQL_DATETIME_SUB: {
                short s = this.m_columns.get(this.m_currentIndex).getTypeMetadata().getType();
                short s2 = TypeUtilities.getIntervalCodeFromConciseType(s);
                if (0 == s2) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(s2);
                }
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                short s = this.m_columns.get(this.m_currentIndex).getTypeMetadata().getType();
                if (TypeUtilities.isCharacterOrBinaryType(s)) {
                    dataWrapper.setInteger(MetadataUtils.getBufferSize(this.m_columns.get(this.m_currentIndex), this.m_hiveClient));
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_currentColumn);
                return false;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData(this.nullableToIsNullable(this.m_columns.get(this.m_currentIndex).getNullable()), dataWrapper, l, l2);
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
            case IS_AUTOINCREMENT: {
                dataWrapper.setNull(this.m_columns.get(this.m_currentIndex).getTypeMetadata().getType());
                return false;
            }
            case IS_GENERATEDCOLUMN: {
                return false;
            }
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_columns.size();
    }

    private void initializeColumn() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            if (this.m_schemas == null) {
                this.m_schemas = this.m_hiveClient.getSchemas();
            }
            if (this.m_columns == null) {
                this.m_columns = new ArrayList();
                this.m_columns.addAll(MetadataUtils.GetColumns(this.m_hiveClient.getCatalogs().get(0), this.m_literalRestrictions, this.m_restrictionPatterns, this.m_filters, this.m_hiveClient, this.m_settings));
                this.m_currentColumn = 0;
                if (this.m_columns.size() != 0) {
                    this.m_currentSchema = this.m_columns.get(0).getSchemaName();
                    this.m_currentTable = this.m_columns.get(0).getTableName();
                }
            }
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_INITIALIZATION_ERR.name(), "Metadata Initialization Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currentIndex >= this.m_columns.size() - 1) {
            return false;
        }
        ++this.m_currentIndex;
        if (this.m_columns.get(this.m_currentIndex).getSchemaName().equalsIgnoreCase(this.m_currentSchema)) {
            if (this.m_columns.get(this.m_currentIndex).getTableName().equalsIgnoreCase(this.m_currentTable)) {
                ++this.m_currentColumn;
            } else {
                this.m_currentTable = this.m_columns.get(this.m_currentIndex).getTableName();
                this.m_currentColumn = 1;
            }
        } else {
            this.m_currentSchema = this.m_columns.get(this.m_currentIndex).getSchemaName();
            this.m_currentTable = this.m_columns.get(this.m_currentIndex).getTableName();
            this.m_currentColumn = 1;
        }
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
        }
        return true;
    }

    private String nullableToIsNullable(Nullable nullable) {
        if (nullable == Nullable.NULLABLE) {
            return "YES";
        }
        if (nullable == Nullable.NO_NULLS) {
            return "NO";
        }
        return "";
    }
}

