/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionResults;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterMetadata;
import com.cloudera.impala.dsi.exceptions.BadDefaultParamException;
import com.cloudera.impala.dsi.exceptions.ExecutingException;
import com.cloudera.impala.dsi.exceptions.OperationCanceledException;
import com.cloudera.impala.dsi.exceptions.ParsingException;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCNativeQueryExecutor;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.impala.hivecommon.querytranslation.IQueryTranslator;
import com.cloudera.impala.jdbc.utils.ParseQueryUtils;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class HiveJDBCDSIExtQueryExecutor
extends SqlQueryExecutor {
    private static final String EXPR_COL_NAME = "EXPR_";
    ArrayList<ParameterMetadata> m_cachedParameterMetadata = new ArrayList();
    private IHiveClient m_client;
    protected HiveJDBCCommonConnection m_connection;
    private boolean m_isDirectExecuteQuery;
    private HiveJDBCNativeQueryExecutor m_nativeQueryExecutor = null;
    private ConnSettingRequestMap m_requestMap;
    private HiveJDBCStatement m_statement;
    protected HiveJDBCSettings m_settings;

    public HiveJDBCDSIExtQueryExecutor(AEStatements aEStatements, SqlDataEngineContext sqlDataEngineContext, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        super(aEStatements, sqlDataEngineContext, iLogger);
        LogUtilities.logFunctionEntrance(iLogger, aEStatements, sqlDataEngineContext, iLogger, hiveJDBCSettings, iHiveClient, "...");
        this.m_aeStatements = aEStatements;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_settings = hiveJDBCSettings;
        this.m_isDirectExecuteQuery = bl;
        this.m_requestMap = connSettingRequestMap;
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_statement.clearCancel();
        super.clearCancel();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_nativeQueryExecutor) {
            this.m_nativeQueryExecutor.close();
        }
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        try {
            if (null == this.m_nativeQueryExecutor) {
                this.m_nativeQueryExecutor = new HiveJDBCNativeQueryExecutor(this.m_log, this.m_client, this.m_statement, this.m_connection, this.m_isDirectExecuteQuery, this.getContext());
            }
            IQueryTranslator iQueryTranslator = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getQueryTranslator();
            ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
            String string = this.translateQuery(executionContexts, iQueryTranslator);
            List<String> list = ParseQueryUtils.splitQueries(string);
            for (String object2 : list) {
                try {
                    this.m_nativeQueryExecutor.executeQuery(object2);
                }
                catch (ErrorException errorException) {
                    HiveJDBCNativeQueryExecutor hiveJDBCNativeQueryExecutor = this.m_nativeQueryExecutor;
                    this.m_nativeQueryExecutor = null;
                    hiveJDBCNativeQueryExecutor.close();
                    throw errorException;
                }
            }
            ArrayList<IColumn> arrayList2 = iQueryTranslator.getSelectColumns();
            if (null != arrayList2) {
                for (IColumn iColumn : arrayList2) {
                    arrayList.add(ColumnMetadata.copyOf(iColumn));
                }
            }
            if (null == this.m_nativeQueryExecutor.getExeContext() || this.m_nativeQueryExecutor.getExeContext().m_isExecutionComplete) {
                ExecutionResults executionResults;
                if (arrayList.size() > 0 && (executionResults = this.m_nativeQueryExecutor.getResults()).getResults().get(0).getResult() instanceof HiveJDBCResultSet) {
                    ((HiveJDBCResultSet)executionResults.getResults().get(0).getResult()).consolidateResultColumnNames(arrayList);
                }
            } else {
                this.m_nativeQueryExecutor.getExeContext().m_sencolumns = arrayList;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            if (null != this.m_nativeQueryExecutor) {
                this.m_nativeQueryExecutor.close();
                this.m_nativeQueryExecutor = null;
            }
            throw operationCanceledException;
        }
        finally {
            super.clearPushedParamData();
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_nativeQueryExecutor) {
            this.m_nativeQueryExecutor.setParameterMetadataForPrepareStatement(this.m_cachedParameterMetadata);
            return this.m_nativeQueryExecutor.getMetadataForParameters();
        }
        this.m_cachedParameterMetadata = super.getMetadataForParameters();
        return this.m_cachedParameterMetadata;
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_nativeQueryExecutor) {
            return this.m_nativeQueryExecutor.getResults();
        }
        ExecutionResults executionResults = super.getResults();
        if (!this.m_settings.m_platformVersionUtils.preservesAliasCase(this.m_settings)) {
            CoreUtils.modifyColumnNameToLowerCase(executionResults);
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion) && !this.m_settings.m_platformVersionUtils.supportsComplexTypesInResults()) {
            CoreUtils.removeComplexColumns(executionResults);
        }
        return executionResults;
    }

    public String getYarnATSGuid() {
        if (null != this.m_nativeQueryExecutor) {
            return this.m_nativeQueryExecutor.getYarnATSGuid();
        }
        return null;
    }

    protected String translateQuery(ExecutionContexts executionContexts, IQueryTranslator iQueryTranslator) throws ErrorException {
        String string = iQueryTranslator.translate(this.m_aeStatements, executionContexts, this, this.m_connection.getSettings().m_platformVersionUtils, this.m_connection.getSettings().m_serverVersion, this.m_settings);
        return string;
    }
}

