/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine;

import com.cloudera.impala.dsi.exceptions.OperationCanceledException;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.CurrentBufferContext;
import com.cloudera.impala.hivecommon.api.HiveExecutionContext;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.api.RowsetBuffer;
import com.cloudera.impala.hivecommon.core.BackgroundFetcherExecutionContextMap;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class BackgroundFetcher
implements Runnable {
    private RowsetBuffer[] m_cachedBuffers;
    private IHiveClient m_client;
    private HiveExecutionContext m_context;
    private ILogger m_logger;
    private Semaphore m_cacheBufferSemaphore;
    private Semaphore m_fetchBufferSemaphore;
    private int m_bufferCacheIndex;
    private int m_bufferFetchIndex;
    private boolean m_isRunning;
    private HiveJDBCSettings m_settings;
    public boolean m_isCancelled;
    public ErrorException m_exception = null;

    public BackgroundFetcher(HiveExecutionContext hiveExecutionContext, IHiveClient iHiveClient, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        this.m_client = iHiveClient;
        this.m_context = hiveExecutionContext;
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
        this.m_bufferFetchIndex = 0;
        this.m_bufferCacheIndex = 0;
        this.m_cacheBufferSemaphore = new Semaphore(0);
        this.m_fetchBufferSemaphore = new Semaphore(1);
        this.m_cachedBuffers = new RowsetBuffer[2];
        this.m_cachedBuffers[0] = this.m_client.makeRowsetBuffer();
        this.m_cachedBuffers[1] = this.m_client.makeRowsetBuffer();
        this.m_isRunning = true;
        this.m_isCancelled = false;
        this.m_context.m_foregroundThreadID = Thread.currentThread().getId();
    }

    @Override
    public void run() {
        try {
            this.m_context.m_backgroundThreadID = Thread.currentThread().getId();
            BackgroundFetcherExecutionContextMap.putContext(this.m_context.m_backgroundThreadID, this.m_context);
        }
        catch (Throwable throwable) {
            this.m_exception = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DOUBLE_BUFFERED_FETCH_ERR.name(), new String[]{String.valueOf(this.m_context.m_foregroundThreadID), String.valueOf(this.m_context.m_backgroundThreadID), throwable.getMessage()});
            this.m_exception.initCause(throwable);
            this.m_isRunning = false;
            this.m_cacheBufferSemaphore.release();
        }
        while (this.isRunning()) {
            try {
                this.m_fetchBufferSemaphore.acquire();
                if (!this.m_isRunning) break;
                this.m_client.fetchRows(this.m_context, this.m_cachedBuffers[this.m_bufferCacheIndex]);
                this.m_cachedBuffers[this.m_bufferCacheIndex].m_isConsumed = false;
                if (!this.m_cachedBuffers[this.m_bufferCacheIndex].m_serverHasMoreRows) {
                    this.m_isRunning = false;
                    continue;
                }
                this.m_bufferCacheIndex = (this.m_bufferCacheIndex + 1) % 2;
            }
            catch (InterruptedException interruptedException) {
                this.m_exception = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DOUBLE_BUFFERED_FETCH_ERR.name(), new String[]{String.valueOf(this.m_context.m_foregroundThreadID), String.valueOf(this.m_context.m_backgroundThreadID), interruptedException.getMessage()});
                this.m_exception.initCause(interruptedException);
                this.m_isRunning = false;
            }
            catch (OperationCanceledException operationCanceledException) {
                this.m_exception = operationCanceledException;
                this.m_isCancelled = true;
                this.m_isRunning = false;
            }
            catch (ErrorException errorException) {
                this.m_exception = errorException;
                this.m_isRunning = false;
            }
            catch (Throwable throwable) {
                this.m_exception = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DOUBLE_BUFFERED_FETCH_ERR.name(), new String[]{String.valueOf(this.m_context.m_foregroundThreadID), String.valueOf(this.m_context.m_backgroundThreadID), throwable.getMessage()});
                this.m_exception.initCause(throwable);
                this.m_isRunning = false;
            }
            finally {
                this.m_cacheBufferSemaphore.release();
            }
        }
        LogUtilities.logDebug("run() terminating. Foreground thread ID: " + String.valueOf(this.m_context.m_foregroundThreadID) + " Background thread ID: " + String.valueOf(this.m_context.m_backgroundThreadID), this.m_logger);
    }

    public boolean getNextBuffer(CurrentBufferContext currentBufferContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, currentBufferContext);
        if (null != this.m_exception) {
            throw this.m_exception;
        }
        if (this.isRunning()) {
            try {
                this.m_cacheBufferSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                this.m_isRunning = false;
                this.m_fetchBufferSemaphore.release();
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DOUBLE_BUFFERED_FETCH_ERR.name(), new String[]{String.valueOf(this.m_context.m_foregroundThreadID), String.valueOf(this.m_context.m_backgroundThreadID), interruptedException.getMessage()});
                errorException.initCause(interruptedException);
                throw errorException;
            }
        }
        if (null != this.m_exception) {
            throw this.m_exception;
        }
        currentBufferContext.m_currentBuffer = this.m_cachedBuffers[this.m_bufferFetchIndex];
        if (currentBufferContext.m_currentBuffer.m_isConsumed) {
            this.m_isRunning = false;
            this.m_fetchBufferSemaphore.release();
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ROWSET_BUFFER_ALREADY_CONSUMED_ERR.name(), new String[]{String.valueOf(this.m_context.m_foregroundThreadID), String.valueOf(this.m_context.m_backgroundThreadID)});
        }
        if (!currentBufferContext.m_currentBuffer.m_serverHasMoreRows) {
            try {
                if (this.m_context.m_fetchEndSemaphore.tryAcquire(this.m_settings.m_fetchEndWaitTime, TimeUnit.SECONDS)) {
                    Throwable throwable = this.m_context.m_backgroundFetcherError;
                    if (null != throwable) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DOUBLE_BUFFERED_FETCH_ERR.name(), new String[]{String.valueOf(this.m_context.m_foregroundThreadID), String.valueOf(this.m_context.m_backgroundThreadID), throwable.getMessage()});
                        errorException.initCause(throwable);
                        throw errorException;
                    }
                    boolean bl = false;
                    return bl;
                }
                try {
                    throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.FETCH_END_SEMAPHORE_ERR.name(), new String[]{String.valueOf(this.m_context.m_foregroundThreadID), String.valueOf(this.m_context.m_backgroundThreadID)});
                }
                catch (InterruptedException interruptedException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DOUBLE_BUFFERED_FETCH_ERR.name(), new String[]{String.valueOf(this.m_context.m_foregroundThreadID), String.valueOf(this.m_context.m_backgroundThreadID), interruptedException.getMessage()});
                    errorException.initCause(interruptedException);
                    throw errorException;
                }
            }
            finally {
                this.m_isRunning = false;
                this.m_fetchBufferSemaphore.release();
            }
        }
        this.m_bufferFetchIndex = (this.m_bufferFetchIndex + 1) % 2;
        this.m_client.checkFetchErrors(currentBufferContext.m_currentBuffer);
        if (this.m_bufferFetchIndex == this.m_bufferCacheIndex) {
            this.m_fetchBufferSemaphore.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        BackgroundFetcher backgroundFetcher = this;
        synchronized (backgroundFetcher) {
            this.m_isRunning = false;
        }
        this.m_fetchBufferSemaphore.release();
    }

    private synchronized boolean isRunning() {
        return this.m_isRunning;
    }
}

