/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.ServiceDiscoveryMode;
import com.cloudera.impala.hivecommon.api.HS2Client;
import com.cloudera.impala.hivecommon.api.HiveServer2ClientFactory;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TBinaryProtocol;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.ErrorException;

public abstract class ServiceDiscoveryFactory
extends HiveServer2ClientFactory {
    protected static final String HOST_PORT_SEPARATOR = ":";
    protected ErrorException m_cacheExp;

    @Override
    public IHiveClient createClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, iLogger, iWarningListener);
        TTransport tTransport = null;
        if (ServiceDiscoveryMode.NO_SERVICE_DISCOVERY == hiveJDBCSettings.m_serviceDiscoveryMode) {
            tTransport = ServiceDiscoveryFactory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
        } else if (null == (tTransport = this.createTransportFromServers(hiveJDBCSettings, tTransport, iLogger, iWarningListener))) {
            this.throwUnableToDiscoverServersError(hiveJDBCSettings.m_serviceDiscoveryMode);
        }
        return new HS2Client(hiveJDBCSettings, new TBinaryProtocol(tTransport), iLogger, iWarningListener);
    }

    @Override
    public abstract boolean supportServiceDiscoveryMode(ServiceDiscoveryMode var1, ILogger var2);

    protected TTransport createTransportFromServers(HiveJDBCSettings hiveJDBCSettings, TTransport tTransport, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        block5: {
            LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, tTransport, iLogger, iWarningListener);
            String string = null;
            do {
                try {
                    string = this.getNextServer(hiveJDBCSettings, iLogger);
                    if (null != string) {
                        String[] stringArray = string.split(HOST_PORT_SEPARATOR);
                        hiveJDBCSettings.m_host = stringArray[0];
                        hiveJDBCSettings.m_port = Integer.parseInt(stringArray[1]);
                        if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech && hiveJDBCSettings.m_krbHostFQDN.equals("_HOST")) {
                            hiveJDBCSettings.m_krbHostFQDN = hiveJDBCSettings.m_host;
                        }
                        LogUtilities.logInfo("Trying to connect to : " + hiveJDBCSettings.m_host + " on port: " + hiveJDBCSettings.m_port, iLogger);
                        tTransport = ServiceDiscoveryFactory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
                        continue;
                    }
                    break block5;
                }
                catch (Exception exception) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_CONNECTION_ERROR.name(), new String[]{String.valueOf((Object)hiveJDBCSettings.m_serviceDiscoveryMode), string, exception.getMessage()});
                    errorException.initCause(exception);
                    this.m_cacheExp = errorException;
                    LogUtilities.logDebug("Unable to connect to server : " + string, iLogger);
                    this.logExceptionAndPostWarning(errorException, iLogger, iWarningListener);
                }
            } while (null == tTransport);
            LogUtilities.logDebug("Connected to server: " + string, iLogger);
        }
        return tTransport;
    }

    protected abstract String getNextServer(HiveJDBCSettings var1, ILogger var2);

    protected void logExceptionAndPostWarning(ErrorException errorException, ILogger iLogger, IWarningListener iWarningListener) {
        LogUtilities.logFunctionEntrance(iLogger, errorException, iLogger, iWarningListener);
        CoreUtils.postWarning(errorException, iWarningListener, WarningCode.GENERAL_WARNING, 101, errorException.getLocalizedMessage());
        HiveJDBCExceptionUtils.logException(errorException, iLogger);
    }

    protected void throwUnableToDiscoverServersError(ServiceDiscoveryMode serviceDiscoveryMode) throws ErrorException {
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_NO_SERVERS.name(), new String[]{String.valueOf((Object)serviceDiscoveryMode)});
        if (null != this.m_cacheExp) {
            this.m_cacheExp.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            errorException.initCause(this.m_cacheExp);
        }
        throw errorException;
    }
}

