/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TSaslClientTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TSocket;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.IMessageSource;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;

class HiveServerPrivilegedAction<Void>
implements PrivilegedAction<Void> {
    private TSocket m_socket;
    private TTransport transKerberos;
    private String m_krbServiceName;
    private String m_krbHostFQDN;
    private IMessageSource m_messagesSource;
    private Locale m_locale;
    private GSSCredential m_userGSSCredential;
    private static final String CREDENTIALS = "javax.security.sasl.credentials";

    public HiveServerPrivilegedAction(TTransport tTransport, TSocket tSocket, String string, String string2, IMessageSource iMessageSource, Locale locale, GSSCredential gSSCredential) {
        this.m_socket = tSocket;
        this.m_krbServiceName = string;
        this.m_krbHostFQDN = string2;
        this.transKerberos = tTransport;
        this.m_messagesSource = iMessageSource;
        this.m_locale = locale;
        this.m_userGSSCredential = gSSCredential;
    }

    public TTransport getTransKerberos() {
        return this.transKerberos;
    }

    @Override
    public Void run() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("javax.security.sasl.qop", "auth,auth-int,auth-conf");
        hashMap.put("javax.security.sasl.server.authentication", "true");
        if (null != this.m_userGSSCredential) {
            hashMap.put(CREDENTIALS, (String)((Object)this.m_userGSSCredential));
        }
        try {
            this.transKerberos = new TSaslClientTransport("GSSAPI", null, this.m_krbServiceName, this.m_krbHostFQDN, hashMap, null, this.m_socket);
        }
        catch (SaslException saslException) {
            String string = this.m_messagesSource.loadMessage(this.m_locale, 101, HiveJDBCMessageKey.CONN_KERBEROS_PRIVILEGED_ACTION.name(), saslException.getMessage());
            RuntimeException runtimeException = new RuntimeException(string, saslException);
            throw runtimeException;
        }
        try {
            this.transKerberos.open();
        }
        catch (TTransportException tTransportException) {
            String string = tTransportException.getMessage();
            if (null == string) {
                string = this.m_messagesSource.loadMessage(this.m_locale, 101, HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_FAILED.name());
            }
            String string2 = this.m_messagesSource.loadMessage(this.m_locale, 101, HiveJDBCMessageKey.CONN_KERBEROS_PRIVILEGED_ACTION.name(), string);
            RuntimeException runtimeException = new RuntimeException(string2, tTransportException);
            throw runtimeException;
        }
        return null;
    }
}

