/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.exceptions.OperationCanceledException;
import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.DatabaseMeatadataInfo;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.TransportMode;
import com.cloudera.impala.hivecommon.api.CurrentBufferContext;
import com.cloudera.impala.hivecommon.api.DataTypeUtilities;
import com.cloudera.impala.hivecommon.api.HS2Buffer;
import com.cloudera.impala.hivecommon.api.HS2ClientWrapper;
import com.cloudera.impala.hivecommon.api.HS2OAuthClientWrapper;
import com.cloudera.impala.hivecommon.api.HS2v6Buffer;
import com.cloudera.impala.hivecommon.api.HiveExecutionContext;
import com.cloudera.impala.hivecommon.api.IExecutorUtility;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.api.RowsetBuffer;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCNativeQueryExecutor;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCPlaceholderTable;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveCommonTablesMetadataSourceRow;
import com.cloudera.impala.hivecommon.dataengine.metadata.MetadataUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TColumn;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TColumnDesc;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchOrientation;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoType;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TOperationHandle;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TProtocolVersion;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRow;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRowSet;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TStatus;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TStatusCode;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeEntry;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeId;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeQualifiers;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TBase;
import com.cloudera.impala.jdbc42.internal.apache.thrift.TException;
import com.cloudera.impala.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.THttpClient;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TSaslClientTransport;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TSocket;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.DiagState;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.ExceptionType;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HS2Client
implements IHiveClient {
    private static final String SHOW_DATABASES_STRING = "SHOW DATABASES";
    private static final int SHOW_DATABASES_RESULT_COLUM_IDX = 0;
    private static final String SHARK_REGEX = ".*[Ss][Hh][Aa][Rr][Kk][Ss][Ee][Rr][Vv][Ee][Rr].*";
    private static final Pattern SHARK_HIVE_VERSION = Pattern.compile("(.*)-shark-(.*)");
    private static final String SET_DASH_V_QUERY_STRING = "set -v";
    private static final int SET_DASH_V_RESULT_COLUM_IDX = 0;
    private static final String SET_CASE = "SET";
    private static final String SPARK_SERVER_NAME = "Spark";
    private static final Map<String, String> HIVE_SPARK_VERSION_MAP = new HashMap<String, String>();
    private static final int COLS_MD_RS_SCHEMA_NAME_IDX = 1;
    private static final int COLS_MD_RS_TABLE_NAME_IDX = 2;
    private static final int COLS_MD_RS_COLUMN_NAME_IDX = 3;
    private static final int COLS_MD_RS_TYPE_NAME_IDX = 5;
    private static final int COLS_MD_RS_REMARKS_IDX = 11;
    private static final String IMPALA_SERVER_NAME = "Impala";
    private boolean m_hasOpenSession;
    private ILogger m_logger;
    private DatabaseMeatadataInfo dbmdInfo;
    private String m_DBType;
    private HS2ClientWrapper m_client;
    private TOpenSessionResp m_openSessionResp;
    private HiveJDBCSettings m_settings;
    private IWarningListener m_warningListener;

    public HS2Client(HiveJDBCSettings hiveJDBCSettings, TProtocol tProtocol, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        this.m_settings = hiveJDBCSettings;
        this.m_DBType = this.m_settings.m_connDBType;
        this.m_client = AuthMech.O_AUTH_CLIENT_CREDENTIALS == this.m_settings.m_authMech ? new HS2OAuthClientWrapper(tProtocol, iLogger, this.m_settings) : new HS2ClientWrapper(tProtocol, iLogger);
        this.m_logger = iLogger;
        this.m_hasOpenSession = false;
        this.m_warningListener = iWarningListener;
        this.openSession();
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.UNION_TYPE, (short)12);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeVarchar(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.VARCHAR_TYPE, (short)12);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeChar(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.CHAR_TYPE, (short)1);
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.ARRAY_TYPE, (short)12);
            DataTypeUtilities.addHiveType(TTypeId.MAP_TYPE, (short)12);
            DataTypeUtilities.addHiveType(TTypeId.STRUCT_TYPE, (short)12);
        }
        if (!this.m_settings.m_Schema.equals("default")) {
            try {
                String string = "USE " + this.m_settings.m_Schema;
                HiveExecutionContext hiveExecutionContext = this.executeStatement(string, null);
                this.closeOperation(hiveExecutionContext);
            }
            catch (Exception exception) {
                if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                    throw (ErrorException)exception;
                }
                CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
                HiveJDBCExceptionUtils.logException(exception, this.m_logger);
                this.m_settings.m_Schema = "default";
            }
        }
    }

    public void cancelDelegationToken(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TCancelDelegationTokenReq tCancelDelegationTokenReq = new TCancelDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string);
        try {
            TCancelDelegationTokenResp tCancelDelegationTokenResp = this.m_client.CancelDelegationToken(tCancelDelegationTokenReq);
            if (TStatusCode.ERROR_STATUS == tCancelDelegationTokenResp.getStatus().getStatusCode()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(tCancelDelegationTokenResp.getStatus().toString(), new String[]{Integer.toString(tCancelDelegationTokenResp.getStatus().getErrorCode()), tCancelDelegationTokenResp.getStatus().toString()});
                throw errorException;
            }
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CANCEL_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    @Override
    public void cancelOperation(HiveExecutionContext hiveExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TCancelOperationReq tCancelOperationReq = new TCancelOperationReq();
            tCancelOperationReq.setOperationHandle(hiveExecutionContext.m_executeResponse.getOperationHandle());
            TCancelOperationResp tCancelOperationResp = this.m_client.CancelOperation(tCancelOperationReq);
            Thread.sleep(1000L);
            String string = "CancelOperation";
            this.checkIfRespNull(tCancelOperationResp, string);
            this.checkResponseStatus(tCancelOperationResp.getStatus(), string);
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_OPERATION_CANCELLATION_ERR.name());
            errorException.initCause(exception);
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.HIVE_OPERATION_CANCELLATION_ERR.name());
        }
    }

    @Override
    public void checkFetchErrors(RowsetBuffer rowsetBuffer) throws ErrorException {
        HS2Buffer hS2Buffer = (HS2Buffer)rowsetBuffer.m_buffer;
        if (TStatusCode.ERROR_STATUS.equals(hS2Buffer.m_hiveServer2Buffer.getStatus().getStatusCode())) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_FETCH_RESULT_ERR.name(), "Buffer Fetch Error");
            throw errorException;
        }
    }

    @Override
    public void closeOperation(HiveExecutionContext hiveExecutionContext) {
        if (hiveExecutionContext.m_hasOpenOperation) {
            try {
                TCloseOperationReq tCloseOperationReq = new TCloseOperationReq();
                tCloseOperationReq.setOperationHandle(hiveExecutionContext.m_fetchResultsReq.getOperationHandle());
                hiveExecutionContext.m_hasOpenOperation = false;
                TCloseOperationResp tCloseOperationResp = this.m_client.CloseOperation(tCloseOperationReq);
                if (TStatusCode.ERROR_STATUS == tCloseOperationResp.getStatus().getStatusCode()) {
                    LogUtilities.logError(this.buildExceptionFromTStatus(HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), tCloseOperationResp.getStatus()), this.m_logger);
                    this.m_warningListener.postWarning(this.buildWarningFromTStatus(HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), tCloseOperationResp.getStatus()));
                }
            }
            catch (Exception exception) {
                LogUtilities.logError(exception, this.m_logger);
                CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name());
            }
        }
    }

    @Override
    public void closeSession() throws ErrorException {
        if (this.m_hasOpenSession) {
            try {
                TCloseSessionReq tCloseSessionReq = new TCloseSessionReq();
                tCloseSessionReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                this.m_client.CloseSession(tCloseSessionReq);
                if (null != this.m_client && null != this.m_client.getInputProtocol() && null != this.m_client.getInputProtocol().getTransport()) {
                    this.m_client.getInputProtocol().getTransport().close();
                }
                this.m_hasOpenSession = false;
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), "Close Session Error");
                errorException.initCause(exception);
                throw errorException;
            }
        }
    }

    @Override
    public void disconnect() throws ErrorException {
        try {
            this.closeSession();
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DICONNECT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        try {
            if (null != this.m_client && null != this.m_client.getInputProtocol() && null != this.m_client.getInputProtocol().getTransport()) {
                this.m_client.getInputProtocol().getTransport().close();
            }
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DICONNECT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public HiveExecutionContext executeStatement(String string, IExecutorUtility iExecutorUtility) throws ErrorException {
        boolean bl = false;
        if (iExecutorUtility instanceof HiveJDBCNativeQueryExecutor) {
            bl = ((HiveJDBCNativeQueryExecutor)iExecutorUtility).getStatement().getAsyncExecution();
        }
        return this.executeStatementInternal(string, iExecutorUtility, bl);
    }

    @Override
    public void executeUpdate(String string, IExecutorUtility iExecutorUtility) throws ErrorException {
        HiveExecutionContext hiveExecutionContext = this.executeStatement(string, iExecutorUtility);
        this.closeOperation(hiveExecutionContext);
    }

    @Override
    public void fetchNRows(HiveExecutionContext hiveExecutionContext, RowsetBuffer rowsetBuffer, int n) throws ErrorException, OperationCanceledException {
        try {
            Object object;
            if (this.isAtLeastV6ProtocolSession()) {
                object = (HS2v6Buffer)rowsetBuffer.m_buffer;
                ((HS2v6Buffer)object).m_bitIndexInCurrentNullByte = 0;
                ((HS2v6Buffer)object).m_indexInNullArray = 0;
                ((HS2v6Buffer)object).m_hasParsedFirstRow = false;
            }
            if (hiveExecutionContext.isCanceled()) {
                throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
            }
            object = hiveExecutionContext.m_fetchResultsReq;
            ((TFetchResultsReq)object).setMaxRows(n);
            HS2Buffer hS2Buffer = (HS2Buffer)rowsetBuffer.m_buffer;
            try {
                hS2Buffer.m_hiveServer2Buffer = this.m_client.FetchResults((TFetchResultsReq)object);
            }
            catch (TException tException) {
                this.closeOperation(hiveExecutionContext);
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), tException.getMessage());
                errorException.initCause(tException);
                throw errorException;
            }
            hiveExecutionContext.m_hasOpenOperation = true;
            if (TStatusCode.SUCCESS_STATUS == hS2Buffer.m_hiveServer2Buffer.getStatus().getStatusCode() || TStatusCode.SUCCESS_WITH_INFO_STATUS == hS2Buffer.m_hiveServer2Buffer.getStatus().getStatusCode()) {
                rowsetBuffer.m_numRows = hS2Buffer.getNumRows();
                boolean bl = rowsetBuffer.m_serverHasMoreRows = 0 < rowsetBuffer.m_numRows;
                if (!rowsetBuffer.m_serverHasMoreRows) {
                    this.closeOperation(hiveExecutionContext);
                }
            }
            if (TStatusCode.ERROR_STATUS == hS2Buffer.m_hiveServer2Buffer.getStatus().getStatusCode()) {
                try {
                    String string;
                    if (null != hS2Buffer.m_hiveServer2Buffer.getStatus().getErrorMessage() && ((string = hS2Buffer.m_hiveServer2Buffer.getStatus().getErrorMessage().toUpperCase()).contains("CANCELED") || string.contains("CANCELLED"))) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                    }
                    throw this.buildExceptionFromTStatus(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), hS2Buffer.m_hiveServer2Buffer.getStatus());
                }
                catch (Throwable throwable) {
                    this.closeOperation(hiveExecutionContext);
                    throw throwable;
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw operationCanceledException;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Row Fetching Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public void fetchRows(HiveExecutionContext hiveExecutionContext, RowsetBuffer rowsetBuffer) throws ErrorException, OperationCanceledException {
        this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
    }

    @Override
    public ArrayList<String> getCatalogs() throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            arrayList.add(this.m_DBType);
            return arrayList;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_CATALOG_ERR.name(), "Catalog Metadata Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(String string, String string2) throws ErrorException {
        if (!this.m_settings.m_platformVersionUtils.supportsGetColumnsAPI(this.m_settings.m_serverVersion)) {
            return this.getColumnsWithDescribeQuery(string, string2);
        }
        HashMap<MetadataSourceColumnTag, String> hashMap = new HashMap<MetadataSourceColumnTag, String>();
        hashMap.put(MetadataSourceColumnTag.SCHEMA_NAME, string);
        hashMap.put(MetadataSourceColumnTag.TABLE_NAME, string2);
        try {
            return this.getColumns(hashMap, null);
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<HiveCommonColumnMetadata>();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws Exception {
        if (!this.m_settings.m_platformVersionUtils.supportsGetColumnsAPI(this.m_settings.m_serverVersion)) {
            return null;
        }
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        if (null != string) {
            string = MetadataUtils.EscapeWildCard(string, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string2) {
            string2 = MetadataUtils.EscapeWildCard(string2, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string3) {
            string3 = MetadataUtils.EscapeWildCard(string3, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != arrayList) {
            if (null == string) {
                string = arrayList.get(MetadataUtils.SCHEMA_PATTERN_IDX);
            }
            if (null == string2) {
                string2 = arrayList.get(MetadataUtils.TABLE_PATTERN_IDX);
            }
            if (null == string3) {
                string3 = arrayList.get(MetadataUtils.COLUMN_PATTERN_IDX);
            }
        }
        HS2Client hS2Client = this;
        synchronized (hS2Client) {
            Cloneable cloneable;
            TOperationHandle tOperationHandle = null;
            try {
                ArrayList<HiveCommonColumnMetadata> arrayList2 = new ArrayList<HiveCommonColumnMetadata>();
                TGetColumnsReq tGetColumnsReq = new TGetColumnsReq();
                tGetColumnsReq.setCatalogName(this.m_DBType);
                tGetColumnsReq.setCatalogNameIsSet(true);
                if (null != string) {
                    tGetColumnsReq.setSchemaName(string);
                    tGetColumnsReq.setSchemaNameIsSet(true);
                }
                if (null != string2) {
                    tGetColumnsReq.setTableName(string2);
                    tGetColumnsReq.setTableNameIsSet(true);
                }
                if (null != string3) {
                    tGetColumnsReq.setColumnName(string3);
                    tGetColumnsReq.setColumnNameIsSet(true);
                }
                tGetColumnsReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                tGetColumnsReq.setSessionHandleIsSet(true);
                TGetColumnsResp tGetColumnsResp = this.m_client.GetColumns(tGetColumnsReq);
                tOperationHandle = tGetColumnsResp.getOperationHandle();
                String string4 = "GetColumns";
                this.checkIfRespNull(tGetColumnsResp, string4);
                this.checkResponseStatus(tGetColumnsResp.getStatus(), string4);
                if (null == tOperationHandle) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GETCOLUMNS_API_CALL_ERR.name(), new String[]{"Unknown", "Unknown"});
                    throw errorException;
                }
                TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                tFetchResultsReq.setOperationHandle(tOperationHandle);
                tFetchResultsReq.setMaxRows(this.m_settings.m_rowsFetchedPerBlock);
                ArrayList arrayList3 = new ArrayList();
                ArrayList arrayList4 = new ArrayList();
                ArrayList arrayList5 = new ArrayList();
                String string5 = "";
                String string6 = "";
                int n = 0;
                boolean bl = false;
                int n2 = 0;
                ArrayList<String> arrayList6 = null;
                String string7 = "";
                do {
                    cloneable = this.m_client.FetchResults(tFetchResultsReq);
                    String string8 = "FetchResults";
                    this.checkIfRespNull((TBase)((Object)cloneable), string8);
                    this.checkResponseStatus(cloneable.getStatus(), string8);
                    TRowSet tRowSet = cloneable.getResults();
                    if (this.isAtLeastV6ProtocolSession()) {
                        n2 = tRowSet.getColumns().get(3).getStringVal().getValuesSize();
                        bl = 0 < n2;
                        arrayList3 = (ArrayList)tRowSet.getColumns().get(3).getStringVal().getValues();
                        arrayList4 = (ArrayList)tRowSet.getColumns().get(5).getStringVal().getValues();
                        arrayList5 = (ArrayList)tRowSet.getColumns().get(11).getStringVal().getValues();
                    } else {
                        n2 = tRowSet.getRowsSize();
                        bl = 0 < n2;
                        arrayList3.clear();
                        arrayList4.clear();
                        arrayList5.clear();
                        for (TRow tRow : tRowSet.getRows()) {
                            arrayList3.add(tRow.getColVals().get(3).getStringVal().getValue());
                            arrayList4.add(tRow.getColVals().get(5).getStringVal().getValue());
                            arrayList5.add(tRow.getColVals().get(11).getStringVal().getValue());
                        }
                    }
                    for (int i = 0; i < n2; ++i, ++n) {
                        if (this.isAtLeastV6ProtocolSession()) {
                            string = tRowSet.getColumns().get(1).getStringVal().getValues().get(i);
                            string2 = tRowSet.getColumns().get(2).getStringVal().getValues().get(i);
                        } else {
                            string = tRowSet.getRows().get(i).getColVals().get(1).getStringVal().getValue();
                            string2 = tRowSet.getRows().get(i).getColVals().get(2).getStringVal().getValue();
                        }
                        if (!string5.equals(string) || !string6.equals(string2)) {
                            string5 = string;
                            string6 = string2;
                            n = 0;
                            arrayList6 = null;
                        }
                        if (((String)arrayList4.get(i)).contains("DECIMAL") || ((String)arrayList4.get(i)).contains("VARCHAR") || ((String)arrayList4.get(i)).contains("CHAR")) {
                            if (null == arrayList6) {
                                arrayList6 = this.getQualifiedTypeNames(string, string2);
                            }
                            string7 = arrayList6.size() > 0 ? arrayList6.get(n) : (String)arrayList4.get(i);
                        } else {
                            string7 = (String)arrayList4.get(i);
                        }
                        if (string7.toUpperCase().contains("ARRAY<") || string7.toUpperCase().contains("STRUCT<") || string7.toUpperCase().contains("MAP<") || string7.toUpperCase().contains("UNIONTYPE<")) {
                            string7 = string7.toUpperCase();
                        }
                        try {
                            arrayList2.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), string, string2, (String)arrayList3.get(i), (String)arrayList5.get(i), DataTypeUtilities.mapHiveTypeNameToSqltype(string7, 2, this.m_settings), string7, 2, this.m_settings));
                            continue;
                        }
                        catch (Exception exception) {
                            this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CREATE_COLUMN_METADATA_ERR.name(), new String[]{string, string2, (String)arrayList3.get(i), string7}));
                        }
                    }
                } while (bl);
                cloneable = arrayList2;
            }
            catch (TTransportException tTransportException) {
                try {
                    ErrorException errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 101, HiveJDBCMessageKey.COMM_LINK_FAILURE.name(), new String[]{null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown"});
                    errorException.initCause(tTransportException);
                    throw errorException;
                    catch (Exception exception) {
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    this.safeCloseOperation(tOperationHandle);
                    throw throwable;
                }
            }
            this.safeCloseOperation(tOperationHandle);
            return cloneable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            return this.m_settings.m_Schema;
        }
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, HiveExecutionContext hiveExecutionContext, CurrentBufferContext currentBufferContext) throws ErrorException {
        HS2Buffer hS2Buffer = (HS2Buffer)currentBufferContext.m_currentBuffer.m_buffer;
        short s = currentBufferContext.m_columnTypes[n];
        return hS2Buffer.getData(n, l, l2, dataWrapper, currentBufferContext.m_currentRowInBuffer, s, hiveExecutionContext.m_query, this.m_settings);
    }

    public String getDelegationToken(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TGetDelegationTokenReq tGetDelegationTokenReq = new TGetDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string, string2);
        try {
            TGetDelegationTokenResp tGetDelegationTokenResp = this.m_client.GetDelegationToken(tGetDelegationTokenReq);
            if (TStatusCode.ERROR_STATUS == tGetDelegationTokenResp.getStatus().getStatusCode()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(tGetDelegationTokenResp.getStatus().toString(), new String[]{Integer.toString(tGetDelegationTokenResp.getStatus().getErrorCode()), tGetDelegationTokenResp.getStatus().toString()});
                throw errorException;
            }
            return tGetDelegationTokenResp.getDelegationToken();
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GET_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string, string2});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    @Override
    public DatabaseMeatadataInfo getDatabaseMetadataInfo() {
        return this.dbmdInfo;
    }

    @Override
    public ILogger getLogger() {
        return this.m_logger;
    }

    @Override
    public ArrayList<ColumnMetadata> getResultSetMetadata(HiveExecutionContext hiveExecutionContext) throws ErrorException {
        try {
            TGetResultSetMetadataReq tGetResultSetMetadataReq = new TGetResultSetMetadataReq();
            tGetResultSetMetadataReq.setOperationHandle(hiveExecutionContext.m_executeResponse.getOperationHandle());
            TGetResultSetMetadataResp tGetResultSetMetadataResp = this.m_client.GetResultSetMetadata(tGetResultSetMetadataReq);
            if (TStatusCode.ERROR_STATUS == tGetResultSetMetadataResp.getStatus().getStatusCode()) {
                try {
                    String string;
                    if (null != tGetResultSetMetadataResp.getStatus().getErrorMessage() && ((string = tGetResultSetMetadataResp.getStatus().getErrorMessage().toUpperCase()).contains("CANCELED") || string.contains("CANCELLED"))) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                    }
                    throw this.buildExceptionFromTStatus(HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), tGetResultSetMetadataResp.getStatus());
                }
                catch (Throwable throwable) {
                    this.closeOperation(hiveExecutionContext);
                    throw throwable;
                }
            }
            if (null == tGetResultSetMetadataResp.getSchema()) {
                return new ArrayList<ColumnMetadata>();
            }
            ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(tGetResultSetMetadataResp.getSchema().getColumns().size());
            for (TColumnDesc tColumnDesc : tGetResultSetMetadataResp.getSchema().getColumns()) {
                TTypeEntry tTypeEntry = tColumnDesc.getTypeDesc().getTypes().get(0);
                if (this.m_settings.m_platformVersionUtils.hasIssueWithNullTypeMetadata(this.m_settings.m_serverVersion) && tTypeEntry.isSetPrimitiveEntry() && tTypeEntry.getPrimitiveEntry().getType().equals(TTypeId.USER_DEFINED_TYPE)) {
                    tTypeEntry.getPrimitiveEntry().setType(TTypeId.BOOLEAN_TYPE);
                }
                String string = this.fullColumnTypeNameBuilder(tTypeEntry);
                arrayList.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), null, null, tColumnDesc.getColumnName(), null, DataTypeUtilities.mapHiveTypeToSqlType(tTypeEntry.getPrimitiveEntry().getType()), string, 2, this.m_settings));
            }
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), "Metadata Result Set Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public ArrayList<String> getSchemas() throws ErrorException {
        if (!this.m_settings.m_platformVersionUtils.supportsGetSchemasAPI(this.m_settings.m_serverVersion) || this.m_settings.m_connDBType.equalsIgnoreCase(IMPALA_SERVER_NAME)) {
            try {
                return this.runCatalogFunction(SHOW_DATABASES_STRING, 0);
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Schema Metadata Error");
                errorException.initCause(exception);
                throw errorException;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        TOperationHandle tOperationHandle = null;
        HS2Client hS2Client = this;
        synchronized (hS2Client) {
            Cloneable cloneable;
            try {
                TGetSchemasReq tGetSchemasReq = new TGetSchemasReq();
                tGetSchemasReq.setCatalogName(this.m_DBType);
                tGetSchemasReq.setCatalogNameIsSet(true);
                tGetSchemasReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                tGetSchemasReq.setSessionHandleIsSet(true);
                TGetSchemasResp tGetSchemasResp = this.m_client.GetSchemas(tGetSchemasReq);
                tOperationHandle = tGetSchemasResp.getOperationHandle();
                String string = "GetSchemas";
                this.checkIfRespNull(tGetSchemasResp, string);
                this.checkResponseStatus(tGetSchemasResp.getStatus(), string);
                if (null == tOperationHandle) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{"getSchemas", "Unknown", "Unknown"});
                    throw errorException;
                }
                TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                tFetchResultsReq.setOperationHandle(tOperationHandle);
                tFetchResultsReq.setMaxRows(this.m_settings.m_rowsFetchedPerBlock);
                TRowSet tRowSet = null;
                boolean bl = false;
                do {
                    cloneable = this.m_client.FetchResults(tFetchResultsReq);
                    String string2 = "FetchResults";
                    this.checkIfRespNull((TBase)((Object)cloneable), string2);
                    this.checkResponseStatus(cloneable.getStatus(), string2);
                    tRowSet = cloneable.getResults();
                    if (this.isAtLeastV6ProtocolSession()) {
                        boolean bl2 = bl = 0 < tRowSet.getColumns().get(0).getStringVal().getValuesSize();
                        if (!bl) continue;
                        arrayList.addAll((ArrayList)tRowSet.getColumns().get(0).getStringVal().getValues());
                        continue;
                    }
                    bl = 0 < tRowSet.getRowsSize();
                    for (TRow tRow : tRowSet.getRows()) {
                        arrayList.add(tRow.getColVals().get(0).getStringVal().getValue());
                    }
                } while (bl);
                Collections.sort(arrayList);
                cloneable = arrayList;
            }
            catch (Exception exception) {
                try {
                    if (exception instanceof ErrorException) {
                        ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Schema Metadata Error");
                    errorException.initCause(exception);
                    throw errorException;
                }
                catch (Throwable throwable) {
                    this.safeCloseOperation(tOperationHandle);
                    throw throwable;
                }
            }
            this.safeCloseOperation(tOperationHandle);
            return cloneable;
        }
    }

    @Override
    public short getStringColumnSize() {
        return this.m_settings.m_stringColumnSize;
    }

    @Override
    public HiveJDBCPlaceholderTable getTable(String string, String string2, String string3) throws ErrorException {
        ArrayList<HiveCommonColumnMetadata> arrayList;
        if (string != null && !string.equalsIgnoreCase(this.m_settings.m_platformCatalog)) {
            return null;
        }
        if (string2 == null || string2.equals("")) {
            string2 = this.getCurrentSchema();
        }
        if (null == (arrayList = this.getColumns(string2, string3)) || arrayList.isEmpty()) {
            return null;
        }
        return new HiveJDBCPlaceholderTable(arrayList);
    }

    @Override
    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(String string) throws ErrorException {
        ArrayList<HiveCommonTablesMetadataSourceRow> arrayList = new ArrayList<HiveCommonTablesMetadataSourceRow>();
        if (string == null || string.equals("")) {
            string = this.getCurrentSchema();
        }
        try {
            String string2 = "SHOW TABLES in " + string;
            for (String string3 : this.runCatalogFunction(string2, this.m_settings.m_tableNameColIndex)) {
                arrayList.add(new HiveCommonTablesMetadataSourceRow(string, string3, "TABLE", null));
            }
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) throws ErrorException {
        if (!this.m_settings.m_platformVersionUtils.supportsGetTablesAPI(this.m_settings.m_serverVersion)) {
            return null;
        }
        String string = map.get((Object)(this.isSwitchRestrict() ? MetadataSourceColumnTag.CATALOG_NAME : MetadataSourceColumnTag.SCHEMA_NAME));
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        if (null != string) {
            string = MetadataUtils.EscapeWildCard(string, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string2) {
            string2 = MetadataUtils.EscapeWildCard(string2, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != arrayList) {
            if (null == string) {
                int n = this.isSwitchRestrict() ? MetadataUtils.CATALOG_PATTERN_IDX : MetadataUtils.SCHEMA_PATTERN_IDX;
                string = arrayList.get(n);
            }
            if (null == string2) {
                string2 = arrayList.get(MetadataUtils.TABLE_PATTERN_IDX);
            }
        }
        ArrayList<HiveCommonTablesMetadataSourceRow> arrayList2 = new ArrayList<HiveCommonTablesMetadataSourceRow>();
        TOperationHandle tOperationHandle = null;
        try {
            Cloneable cloneable;
            TGetTablesReq tGetTablesReq = new TGetTablesReq();
            if (null != string) {
                tGetTablesReq.setSchemaName(string);
                tGetTablesReq.setSchemaNameIsSet(true);
            }
            if (null != string2) {
                tGetTablesReq.setTableName(string2);
                tGetTablesReq.setTableNameIsSet(true);
            }
            tGetTablesReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            tGetTablesReq.setSessionHandleIsSet(true);
            TGetTablesResp tGetTablesResp = this.m_client.GetTables(tGetTablesReq);
            tOperationHandle = tGetTablesResp.getOperationHandle();
            String string3 = "GetTables";
            this.checkIfRespNull(tGetTablesResp, string3);
            this.checkResponseStatus(tGetTablesResp.getStatus(), string3);
            if (null == tOperationHandle) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{"getTables", "Unknown", "Unknown"});
                throw errorException;
            }
            TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
            tFetchResultsReq.setOperationHandle(tOperationHandle);
            tFetchResultsReq.setMaxRows(this.m_settings.m_rowsFetchedPerBlock);
            TRowSet tRowSet = null;
            boolean bl = false;
            int n = 0;
            do {
                cloneable = this.m_client.FetchResults(tFetchResultsReq);
                String string4 = "FetchResults";
                this.checkIfRespNull((TBase)((Object)cloneable), string4);
                this.checkResponseStatus(cloneable.getStatus(), string4);
                tRowSet = cloneable.getResults();
                if (this.isAtLeastV6ProtocolSession()) {
                    List<TColumn> list = tRowSet.getColumns();
                    n = list.get(2).getStringVal().getValuesSize();
                    bl = 0 < n;
                    for (int i = 0; n > i; ++i) {
                        arrayList2.add(new HiveCommonTablesMetadataSourceRow(((TColumn)list.get(1)).getStringVal().getValues().get(i), ((TColumn)list.get(2)).getStringVal().getValues().get(i), ((TColumn)list.get(3)).getStringVal().getValues().get(i), ((TColumn)list.get(4)).getStringVal().getValues().get(i)));
                    }
                } else {
                    n = tRowSet.getRowsSize();
                    bl = 0 < n;
                    for (TRow tRow : tRowSet.getRows()) {
                        arrayList2.add(new HiveCommonTablesMetadataSourceRow(tRow.getColVals().get(1).getStringVal().getValue(), tRow.getColVals().get(2).getStringVal().getValue(), tRow.getColVals().get(3).getStringVal().getValue(), tRow.getColVals().get(4).getStringVal().getValue()));
                    }
                }
            } while (bl);
            cloneable = arrayList2;
            this.safeCloseOperation(tOperationHandle);
            return cloneable;
        }
        catch (TTransportException tTransportException) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 101, HiveJDBCMessageKey.COMM_LINK_FAILURE.name(), new String[]{null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown"});
            errorException.initCause(tTransportException);
            throw errorException;
            catch (Exception exception) {
                CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
                HiveJDBCExceptionUtils.logException(exception, this.m_logger);
                ArrayList<HiveCommonTablesMetadataSourceRow> arrayList3 = new ArrayList<HiveCommonTablesMetadataSourceRow>();
                return arrayList3;
            }
        }
        finally {
            this.safeCloseOperation(tOperationHandle);
        }
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isSwitchRestrict() {
        return this.m_settings.m_switchCataANDSchema;
    }

    @Override
    public boolean isSessionValid() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.getServerVersion();
        }
        catch (ErrorException errorException) {
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            return false;
        }
        return true;
    }

    @Override
    public RowsetBuffer<HS2Buffer> makeRowsetBuffer() {
        RowsetBuffer<HS2Buffer> rowsetBuffer = new RowsetBuffer<HS2Buffer>();
        rowsetBuffer.m_buffer = this.isAtLeastV6ProtocolSession() ? new HS2v6Buffer() : new HS2Buffer();
        return rowsetBuffer;
    }

    @Override
    public void parseRow(CurrentBufferContext currentBufferContext) throws ErrorException {
        if (this.isAtLeastV6ProtocolSession()) {
            HS2v6Buffer hS2v6Buffer = (HS2v6Buffer)currentBufferContext.m_currentBuffer.m_buffer;
            if (!hS2v6Buffer.m_hasParsedFirstRow) {
                hS2v6Buffer.m_hasParsedFirstRow = true;
                hS2v6Buffer.m_bitIndexInCurrentNullByte = 0;
                hS2v6Buffer.m_indexInNullArray = 0;
            } else if (++hS2v6Buffer.m_bitIndexInCurrentNullByte == 8) {
                hS2v6Buffer.m_bitIndexInCurrentNullByte = 0;
                ++hS2v6Buffer.m_indexInNullArray;
            }
        }
    }

    public HiveExecutionContext pollForOperationCompletion(HiveExecutionContext hiveExecutionContext) throws ErrorException {
        if (hiveExecutionContext.isCanceled()) {
            this.cancelOperation(hiveExecutionContext);
            throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
        }
        try {
            TExecuteStatementResp tExecuteStatementResp = hiveExecutionContext.m_executeResponse;
            TGetOperationStatusReq tGetOperationStatusReq = new TGetOperationStatusReq();
            if (null == hiveExecutionContext.m_executeResponse.getOperationHandle()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_NULL_OPERATION_HANDLE.name(), new String[]{hiveExecutionContext.m_query});
                throw errorException;
            }
            tGetOperationStatusReq.setOperationHandle(tExecuteStatementResp.getOperationHandle());
            tGetOperationStatusReq.setOperationHandleIsSet(true);
            TGetOperationStatusResp tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
            block11: while (!hiveExecutionContext.isCanceled() && !hiveExecutionContext.m_isExecutionComplete) {
                if (TStatusCode.SUCCESS_STATUS == tGetOperationStatusResp.getStatus().getStatusCode() || TStatusCode.SUCCESS_WITH_INFO_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    switch (tGetOperationStatusResp.getOperationState()) {
                        case CLOSED_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_CLOSED_SERVER.name(), new String[]{hiveExecutionContext.m_query});
                            throw errorException;
                        }
                        case CANCELED_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL_SERVER.name(), new String[]{hiveExecutionContext.m_query});
                            throw errorException;
                        }
                        case ERROR_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{String.valueOf(tGetOperationStatusResp.getErrorCode()), tGetOperationStatusResp.isSetErrorMessage() ? tGetOperationStatusResp.getErrorMessage() : "No error message available from the server", hiveExecutionContext.m_query});
                            throw errorException;
                        }
                        case UKNOWN_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_INVALID_STATE.name(), new String[]{hiveExecutionContext.m_query});
                            throw errorException;
                        }
                        case PENDING_STATE: 
                        case RUNNING_STATE: 
                        case INITIALIZED_STATE: {
                            this.timeoutCheck(hiveExecutionContext);
                            Thread.sleep(this.m_settings.m_asyncExecPollInterval);
                            tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
                            continue block11;
                        }
                        case FINISHED_STATE: {
                            hiveExecutionContext.m_isExecutionComplete = true;
                            continue block11;
                        }
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_INVALID_STATE.name(), new String[]{hiveExecutionContext.m_query});
                    throw errorException;
                }
                if (TStatusCode.ERROR_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{Integer.toString(tGetOperationStatusResp.getStatus().getErrorCode()), tGetOperationStatusResp.getStatus().toString(), hiveExecutionContext.m_query});
                    throw errorException;
                }
                if (TStatusCode.INVALID_HANDLE_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_INVALID_OPERATION_HANDLE.name(), new String[]{hiveExecutionContext.m_query});
                    throw errorException;
                }
                if (TStatusCode.STILL_EXECUTING_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    this.timeoutCheck(hiveExecutionContext);
                    Thread.sleep(this.m_settings.m_asyncExecPollInterval);
                    tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
                    continue;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_UNRECOGNIZED_STATUS_CODE.name(), new String[]{hiveExecutionContext.m_query});
                throw errorException;
            }
            if (hiveExecutionContext.isCanceled()) {
                this.cancelOperation(hiveExecutionContext);
                throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
            }
            if (!hiveExecutionContext.m_isManualCanceled.get() && hiveExecutionContext.m_isExecutionComplete) {
                hiveExecutionContext.m_fetchResultsReq = new TFetchResultsReq();
                hiveExecutionContext.m_fetchResultsReq.setOrientation(TFetchOrientation.FETCH_NEXT);
                hiveExecutionContext.m_fetchResultsReq.setOperationHandle(tExecuteStatementResp.getOperationHandle());
                hiveExecutionContext.m_hasOpenOperation = true;
            }
            return hiveExecutionContext;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            if (exception instanceof TTransportException && null != exception.getCause() && exception.getCause() instanceof SocketTimeoutException) {
                if (0L != hiveExecutionContext.m_timeoutVal) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{hiveExecutionContext.m_query}, (Throwable)exception, ExceptionType.TIME_OUT);
                    throw errorException;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STMT_EXEC_SOCKETTIMEOUT_ERR.name(), new String[]{hiveExecutionContext.m_query}, (Throwable)exception);
                throw errorException;
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{exception.getMessage(), "HY000", hiveExecutionContext.m_query}, (Throwable)exception);
            throw errorException;
        }
    }

    public void renewDelegationToken(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TRenewDelegationTokenReq tRenewDelegationTokenReq = new TRenewDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string);
        try {
            TRenewDelegationTokenResp tRenewDelegationTokenResp = this.m_client.RenewDelegationToken(tRenewDelegationTokenReq);
            if (TStatusCode.ERROR_STATUS == tRenewDelegationTokenResp.getStatus().getStatusCode()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(tRenewDelegationTokenResp.getStatus().toString(), new String[]{Integer.toString(tRenewDelegationTokenResp.getStatus().getErrorCode()), tRenewDelegationTokenResp.getStatus().toString()});
                throw errorException;
            }
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.RENEW_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSchema(String string) {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            this.m_settings.m_Schema = string;
        }
    }

    @Override
    public void setWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    protected ErrorException buildExceptionFromTStatus(String string, TStatus tStatus) {
        if (null != tStatus.getInfoMessages() && tStatus.getInfoMessages().size() > 0) {
            String[] stringArray = new String[tStatus.getInfoMessages().size()];
            tStatus.getInfoMessages().toArray(stringArray);
            return HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string, stringArray);
        }
        return HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string, new String[]{tStatus.getErrorMessage(), Integer.toString(tStatus.getErrorCode())});
    }

    protected void checkIfRespNull(TBase tBase, String string) throws ErrorException {
        if (null == tBase) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{string, "Unknown", "Unknown"});
            throw errorException;
        }
    }

    protected void checkOpenSessionStatus() throws ErrorException {
        try {
            String string = "OpenSession";
            this.checkIfRespNull(this.m_openSessionResp, string);
            this.checkResponseStatus(this.m_openSessionResp.getStatus(), string);
        }
        catch (ErrorException errorException) {
            this.m_hasOpenSession = false;
            throw errorException;
        }
    }

    protected String getServerVersion() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TGetInfoReq tGetInfoReq = new TGetInfoReq();
            tGetInfoReq.setInfoType(TGetInfoType.CLI_DBMS_VER);
            tGetInfoReq.setInfoTypeIsSet(true);
            tGetInfoReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            tGetInfoReq.setSessionHandleIsSet(true);
            TGetInfoResp tGetInfoResp = this.m_client.GetInfo(tGetInfoReq);
            String string = "GetInfo - Server Version";
            this.checkIfRespNull(tGetInfoResp, string);
            this.checkResponseStatus(tGetInfoResp.getStatus(), string);
            return tGetInfoResp.getInfoValue().getStringValue();
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            }
            ErrorException errorException = null != exception.getMessage() ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_GET_SERVER_VERSION_ERROR.name(), exception.getMessage()) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_GET_SERVER_VERSION_ERROR.name(), "no details available");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected void checkResponseStatus(TStatus tStatus, String string) throws ErrorException {
        if (null == tStatus) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{string, "Unknown", "Unknown"});
            throw errorException;
        }
        if (TStatusCode.SUCCESS_STATUS != tStatus.getStatusCode() && TStatusCode.SUCCESS_WITH_INFO_STATUS != tStatus.getStatusCode()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{string, Integer.toString(tStatus.getErrorCode()), tStatus.toString()});
            throw errorException;
        }
    }

    protected boolean isAtLeastV6ProtocolSession() {
        if (this.m_hasOpenSession && null != this.m_openSessionResp) {
            TProtocolVersion tProtocolVersion = this.m_openSessionResp.getServerProtocolVersion();
            return tProtocolVersion.getValue() >= TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue();
        }
        return false;
    }

    protected void openSession() throws ErrorException {
        try {
            TOpenSessionReq tOpenSessionReq = new TOpenSessionReq();
            tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
            tOpenSessionReq.setClient_protocolIsSet(true);
            if (null != this.m_settings.m_delegationUID) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(this.m_settings.m_platformDelegationUIDPropertyKey, this.m_settings.m_delegationUID);
                tOpenSessionReq.setConfiguration(hashMap);
            }
            if (AuthMech.UIDPWD == this.m_settings.m_authMech && TransportMode.BINARY == this.m_settings.m_transportMode) {
                tOpenSessionReq.setUsername(this.m_settings.m_username);
                tOpenSessionReq.setPassword(this.m_settings.m_password);
            } else if (this.m_settings.m_platformVersionUtils.sendUidViaOpenSessionReq(this.m_settings.m_authMech) && null != this.m_settings.m_username) {
                tOpenSessionReq.setUsername(this.m_settings.m_username);
            }
            if (!this.m_settings.m_platformVersionUtils.isServerVersionSet(this.m_settings.m_serverVersion)) {
                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                this.checkOpenSessionStatus();
                this.m_hasOpenSession = true;
                this.m_settings.m_strServerVersion = this.getServerVersion();
                if (this.m_settings.m_connDBType == IMPALA_SERVER_NAME) {
                    this.regroupImpalaServerVersion();
                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
                } else {
                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
                    this.setSparkServerVersion();
                }
                this.setDbmsProdName();
                if (this.m_settings.m_platformVersionUtils.supportsV3Protocol(this.m_settings.m_serverVersion) || this.m_settings.m_platformVersionUtils.supportsV6Protocol(this.m_settings.m_serverVersion)) {
                    this.safeCloseSession();
                    this.m_hasOpenSession = false;
                }
            }
            if (!this.m_settings.m_platformVersionUtils.supportPushdownCatalogFilter(this.m_settings.m_serverVersion)) {
                this.m_settings.m_pushdownCatalogFunctionFilters = false;
            }
            if (this.m_settings.m_platformVersionUtils.supportsV6Protocol(this.m_settings.m_serverVersion)) {
                tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6);
            } else if (this.m_settings.m_platformVersionUtils.supportsV3Protocol(this.m_settings.m_serverVersion)) {
                tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
            }
            if (!this.m_hasOpenSession) {
                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                this.checkOpenSessionStatus();
                this.m_hasOpenSession = true;
            }
            this.dbmdInfo = new DatabaseMeatadataInfo(this.m_settings.m_dbmsName, this.m_settings.m_strServerVersion);
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            }
            ErrorException errorException = null != exception.getMessage() ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), exception.getMessage()) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR_NO_DETAIL.name());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected void setDbmsProdName() throws ErrorException, TException {
        TGetInfoReq tGetInfoReq = new TGetInfoReq();
        tGetInfoReq.setInfoType(TGetInfoType.CLI_DBMS_NAME);
        tGetInfoReq.setInfoTypeIsSet(true);
        tGetInfoReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
        tGetInfoReq.setSessionHandleIsSet(true);
        TGetInfoResp tGetInfoResp = this.m_client.GetInfo(tGetInfoReq);
        String string = "GetInfo - Product Name";
        this.checkIfRespNull(tGetInfoResp, string);
        this.checkResponseStatus(tGetInfoResp.getStatus(), string);
        this.m_settings.m_dbmsName = tGetInfoResp.getInfoValue().getStringValue();
    }

    protected ArrayList<String> runCatalogFunction(String string, int n) throws ErrorException, Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        HiveExecutionContext hiveExecutionContext = this.executeStatement(string, null);
        RowsetBuffer<HS2Buffer> rowsetBuffer = this.makeRowsetBuffer();
        do {
            int n2;
            this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
            this.checkFetchErrors(rowsetBuffer);
            if (this.isAtLeastV6ProtocolSession()) {
                n2 = ((HS2Buffer)rowsetBuffer.m_buffer).m_hiveServer2Buffer.getResults().getColumnsSize();
                if (n2 <= n) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CATALOG_FUNCTION_COL_IDX_ERR.name(), new String[]{string, Integer.toString(n), Integer.toString(n2)});
                    throw errorException;
                }
                arrayList.addAll((ArrayList)((HS2Buffer)rowsetBuffer.m_buffer).m_hiveServer2Buffer.getResults().getColumns().get(n).getStringVal().getValues());
                continue;
            }
            n2 = ((HS2Buffer)rowsetBuffer.m_buffer).getNumRows();
            for (int i = 0; i < n2; ++i) {
                int n3 = ((HS2Buffer)rowsetBuffer.m_buffer).m_hiveServer2Buffer.getResults().getRows().get(i).getColVals().size();
                if (n3 <= n) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CATALOG_FUNCTION_COL_IDX_ERR.name(), new String[]{string, Integer.toString(n), Integer.toString(n3)});
                    throw errorException;
                }
                arrayList.add(((HS2Buffer)rowsetBuffer.m_buffer).getString(i, n));
            }
        } while (rowsetBuffer.m_serverHasMoreRows);
        this.closeOperation(hiveExecutionContext);
        Collections.sort(arrayList);
        return arrayList;
    }

    protected void safeCloseOperation(TOperationHandle tOperationHandle) throws ErrorException {
        TStatus tStatus = null;
        try {
            if (null != tOperationHandle) {
                TCloseOperationReq tCloseOperationReq = new TCloseOperationReq();
                tCloseOperationReq.setOperationHandle(tOperationHandle);
                TCloseOperationResp tCloseOperationResp = this.m_client.CloseOperation(tCloseOperationReq);
                String string = "CloseOperation";
                this.checkIfRespNull(tCloseOperationResp, string);
                this.checkResponseStatus(tCloseOperationResp.getStatus(), string);
            }
        }
        catch (TTransportException tTransportException) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 101, HiveJDBCMessageKey.COMM_LINK_FAILURE.name(), new String[]{null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown"});
            errorException.initCause(tTransportException);
            throw errorException;
        }
        catch (ErrorException errorException) {
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            if (null != tStatus) {
                this.m_warningListener.postWarning(this.buildWarningFromTStatus(HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), tStatus));
            }
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
    }

    protected void safeCloseSession() throws ErrorException {
        try {
            TCloseSessionReq tCloseSessionReq = new TCloseSessionReq();
            tCloseSessionReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            tCloseSessionReq.setSessionHandleIsSet(true);
            TCloseSessionResp tCloseSessionResp = this.m_client.CloseSession(tCloseSessionReq);
            String string = "CloseSession";
            this.checkIfRespNull(tCloseSessionResp, string);
            this.checkResponseStatus(tCloseSessionResp.getStatus(), string);
        }
        catch (TTransportException tTransportException) {
            ErrorException errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 101, HiveJDBCMessageKey.COMM_LINK_FAILURE.name(), new String[]{null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown"});
            errorException.initCause(tTransportException);
            throw errorException;
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
    }

    private Warning buildWarningFromTStatus(String string, TStatus tStatus) {
        if (null != tStatus.getInfoMessages() && tStatus.getInfoMessages().size() > 0) {
            String[] stringArray = new String[tStatus.getInfoMessages().size()];
            tStatus.getInfoMessages().toArray(stringArray);
            return new Warning(WarningCode.GENERAL_WARNING, 101, string, stringArray);
        }
        return new Warning(WarningCode.GENERAL_WARNING, 101, string, new String[]{tStatus.getErrorMessage(), Integer.toString(tStatus.getErrorCode())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HiveExecutionContext executeStatementInternal(String string, IExecutorUtility iExecutorUtility, boolean bl) throws ErrorException {
        boolean bl2 = false;
        try {
            Object object;
            Object object2;
            long l = 0L;
            boolean bl3 = this.m_settings.m_platformVersionUtils.supportsAsynchronousOperations(this.m_settings.m_serverVersion);
            HiveExecutionContext hiveExecutionContext = new HiveExecutionContext();
            TExecuteStatementReq tExecuteStatementReq = new TExecuteStatementReq();
            tExecuteStatementReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            if (string.startsWith(SET_CASE)) {
                object2 = "\n";
                object = "\r";
                String string2 = " ";
                boolean bl4 = this.m_settings.m_platformVersionUtils.supportsNewLineCharacter(this.m_settings.m_serverVersion);
                if (!bl4) {
                    string = string.replace((CharSequence)object2, string2).replace((CharSequence)object, string2);
                }
            }
            tExecuteStatementReq.setStatement(string);
            hiveExecutionContext.m_query = string;
            if (bl3) {
                tExecuteStatementReq.setRunAsyncIsSet(true);
                tExecuteStatementReq.setRunAsync(true);
            }
            object = this;
            synchronized (object) {
                if (null != iExecutorUtility && 0 != iExecutorUtility.getQueryTimeout()) {
                    l = iExecutorUtility.getQueryTimeout();
                    bl2 = true;
                    if (!bl3) {
                        this.setSocketTimeout(iExecutorUtility.getQueryTimeout());
                    } else {
                        this.setSocketTimeout(this.m_settings.m_timeout);
                    }
                } else {
                    this.setSocketTimeout(this.m_settings.m_timeout);
                }
                if (null != iExecutorUtility) {
                    hiveExecutionContext.setStatement(iExecutorUtility.getStatement());
                    if (hiveExecutionContext.isCanceled()) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
                    }
                }
                hiveExecutionContext.m_executeResponse = object2 = this.m_client.ExecuteStatement(tExecuteStatementReq);
            }
            hiveExecutionContext.m_startTime = System.currentTimeMillis();
            hiveExecutionContext.m_timeoutVal = l;
            if (null != iExecutorUtility) {
                iExecutorUtility.setExeContext(hiveExecutionContext);
            }
            if (TStatusCode.ERROR_STATUS == ((TExecuteStatementResp)object2).getStatus().getStatusCode()) {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{Integer.toString(((TExecuteStatementResp)object2).getStatus().getErrorCode()), ((TExecuteStatementResp)object2).getStatus().toString(), string});
                throw object;
            }
            if (bl) {
                return hiveExecutionContext;
            }
            return this.pollForOperationCompletion(hiveExecutionContext);
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (TTransportException tTransportException) {
            if (null != tTransportException.getCause() && tTransportException.getCause() instanceof SocketTimeoutException) {
                if (bl2) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{string}, (Throwable)tTransportException, ExceptionType.TIME_OUT);
                    throw errorException;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STMT_EXEC_SOCKETTIMEOUT_ERR.name(), new String[]{string}, (Throwable)tTransportException);
                throw errorException;
            }
            ErrorException errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 101, HiveJDBCMessageKey.COMM_LINK_FAILURE.name(), new String[]{null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown"});
            errorException.initCause(tTransportException);
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{exception.getMessage(), "HY000", string}, (Throwable)exception);
            throw errorException;
        }
    }

    private String fullColumnTypeNameBuilder(TTypeEntry tTypeEntry) {
        TTypeQualifiers tTypeQualifiers = tTypeEntry.getPrimitiveEntry().getTypeQualifiers();
        TTypeId tTypeId = tTypeEntry.getPrimitiveEntry().getType();
        if (this.m_settings.m_platformVersionUtils.supportsCharLength(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("CHAR_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("characterMaximumLength").getI32Value();
            return "CHAR(" + n + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsVarcharLength(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("VARCHAR_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("characterMaximumLength").getI32Value();
            return "VARCHAR(" + n + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsDecimalPrecisionAndScale(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("DECIMAL_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("precision").getI32Value();
            int n2 = tTypeQualifiers.getQualifiers().get("scale").getI32Value();
            return "DECIMAL(" + n + ", " + n2 + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
            if (tTypeId.name().equalsIgnoreCase("ARRAY_TYPE")) {
                return "ARRAY";
            }
            if (tTypeId.name().equalsIgnoreCase("STRUCT_TYPE")) {
                return "STRUCT";
            }
            if (tTypeId.name().equalsIgnoreCase("MAP_TYPE")) {
                return "MAP";
            }
        }
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("UNION_TYPE")) {
            return "UNION";
        }
        return "null";
    }

    private void setSocketTimeout(int n) throws ErrorException {
        if (this.m_client.getOutputProtocol().getTransport() instanceof THttpClient) {
            ((THttpClient)this.m_client.getOutputProtocol().getTransport()).setReadTimeout(n);
        } else {
            Object object;
            TSocket tSocket = null;
            if (this.m_client.getOutputProtocol().getTransport() instanceof TSocket) {
                tSocket = (TSocket)this.m_client.getOutputProtocol().getTransport();
            } else if (this.m_client.getOutputProtocol().getTransport() instanceof TSaslClientTransport && ((TSaslClientTransport)(object = (TSaslClientTransport)this.m_client.getOutputProtocol().getTransport())).getUnderlyingTransport() instanceof TSocket) {
                tSocket = (TSocket)((TSaslClientTransport)object).getUnderlyingTransport();
            }
            if (null != tSocket) {
                tSocket.setTimeout(n);
            } else {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SET_SOCKETTIMEOUT_ERR.name(), new String[]{"Null socket"});
                throw object;
            }
        }
    }

    private void timeoutCheck(HiveExecutionContext hiveExecutionContext) throws ErrorException {
        if (0L != hiveExecutionContext.m_timeoutVal && System.currentTimeMillis() - hiveExecutionContext.m_startTime >= hiveExecutionContext.m_timeoutVal) {
            hiveExecutionContext.m_isManualCanceled.set(true);
            this.cancelOperation(hiveExecutionContext);
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{hiveExecutionContext.m_query}, ExceptionType.TIME_OUT);
            throw errorException;
        }
    }

    private void regroupImpalaServerVersion() {
        String[] stringArray = this.m_settings.m_strServerVersion.split("-");
        if (stringArray.length > 1) {
            try {
                Integer.parseInt(stringArray[0].substring(0, 1));
                this.m_settings.m_strServerVersion = stringArray[0] + "-" + stringArray[1];
            }
            catch (NumberFormatException numberFormatException) {
                this.m_settings.m_strServerVersion = stringArray[1] + "-" + stringArray[0];
            }
        }
    }

    private ArrayList<String> getQualifiedTypeNames(String string, String string2) throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = string == null || string.equals("") ? this.getCurrentSchema() + "." : string + ".";
            HiveExecutionContext hiveExecutionContext = this.executeStatement("DESCRIBE " + string3 + string2, null);
            RowsetBuffer<HS2Buffer> rowsetBuffer = this.makeRowsetBuffer();
            do {
                String string4;
                this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                int n = ((HS2Buffer)rowsetBuffer.m_buffer).getNumRows();
                for (int i = 0; i < n && null != (string4 = ((HS2Buffer)rowsetBuffer.m_buffer).getString(i, 1)); ++i) {
                    arrayList.add(string4.toUpperCase().trim());
                }
            } while (rowsetBuffer.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            return arrayList;
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<String>();
        }
    }

    private ArrayList<HiveCommonColumnMetadata> getColumnsWithDescribeQuery(String string, String string2) throws ErrorException {
        ArrayList<HiveCommonColumnMetadata> arrayList = new ArrayList<HiveCommonColumnMetadata>();
        try {
            if (string2.contains("\\")) {
                return new ArrayList<HiveCommonColumnMetadata>();
            }
            boolean bl = null != string && !string.equals("");
            String string3 = "`" + (bl ? string : this.getCurrentSchema()) + "`.`" + string2 + "`";
            HiveExecutionContext hiveExecutionContext = this.executeStatement("DESCRIBE " + string3, null);
            if (hiveExecutionContext == null) {
                return new ArrayList<HiveCommonColumnMetadata>();
            }
            RowsetBuffer<HS2Buffer> rowsetBuffer = this.makeRowsetBuffer();
            block2: do {
                int n;
                this.fetchNRows(hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                ArrayList arrayList2 = new ArrayList();
                ArrayList arrayList3 = new ArrayList();
                ArrayList arrayList4 = new ArrayList();
                if (this.isAtLeastV6ProtocolSession()) {
                    arrayList2 = (ArrayList)((HS2Buffer)rowsetBuffer.m_buffer).m_hiveServer2Buffer.getResults().getColumns().get(0).getStringVal().getValues();
                    arrayList3 = (ArrayList)((HS2Buffer)rowsetBuffer.m_buffer).m_hiveServer2Buffer.getResults().getColumns().get(1).getStringVal().getValues();
                    arrayList4 = (ArrayList)((HS2Buffer)rowsetBuffer.m_buffer).m_hiveServer2Buffer.getResults().getColumns().get(2).getStringVal().getValues();
                } else {
                    n = ((HS2Buffer)rowsetBuffer.m_buffer).getNumRows();
                    for (int i = 0; i < n; ++i) {
                        arrayList2.add(((HS2Buffer)rowsetBuffer.m_buffer).getString(i, 0));
                        arrayList3.add(((HS2Buffer)rowsetBuffer.m_buffer).getString(i, 1));
                        arrayList4.add(((HS2Buffer)rowsetBuffer.m_buffer).getString(i, 2));
                    }
                }
                for (n = 0; n < arrayList2.size(); ++n) {
                    String string4 = (String)arrayList3.get(n);
                    if (null == string4 || 0 == string4.length()) {
                        rowsetBuffer.m_serverHasMoreRows = false;
                        continue block2;
                    }
                    string4 = string4.toUpperCase();
                    short s = DataTypeUtilities.mapHiveTypeNameToSqltype(string4, 2, this.m_settings);
                    arrayList.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), string, string2, (String)arrayList2.get(n), (String)arrayList4.get(n), s, string4, 2, this.m_settings));
                }
            } while (rowsetBuffer.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            return arrayList;
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage());
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<HiveCommonColumnMetadata>();
        }
    }

    private void setSparkServerVersion() throws ErrorException, Exception {
        Object object;
        boolean bl = false;
        String string = null;
        if (this.m_settings.m_dbmsName.contains(SPARK_SERVER_NAME)) {
            bl = true;
            string = this.m_settings.m_strServerVersion;
        } else if (this.m_settings.m_strServerVersion.contains("shark")) {
            bl = true;
            object = SHARK_HIVE_VERSION.matcher(this.m_settings.m_strServerVersion);
            if (((Matcher)object).find()) {
                string = ((Matcher)object).group(2);
            }
        } else if (!this.m_settings.m_dbmsName.contains(IMPALA_SERVER_NAME)) {
            object = this.runCatalogFunction(SET_DASH_V_QUERY_STRING, 0);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                if (!((String)((ArrayList)object).get(i)).matches(SHARK_REGEX)) continue;
                bl = true;
                string = HIVE_SPARK_VERSION_MAP.get(this.m_settings.m_strServerVersion.substring(0, 4));
            }
        }
        if (bl && SPARK_SERVER_NAME == this.m_settings.m_connDBType) {
            this.m_settings.m_strServerVersion = string;
            this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
        }
        if (bl && SPARK_SERVER_NAME != this.m_settings.m_connDBType || !bl && SPARK_SERVER_NAME == this.m_settings.m_connDBType) {
            object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), "Incorrect Server Type Connected To.");
            throw object;
        }
    }

    static {
        HIVE_SPARK_VERSION_MAP.put("0.11", "0.9");
        HIVE_SPARK_VERSION_MAP.put("0.12", "1.1");
    }
}

