/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.dsi.dataengine.filters;

import com.cloudera.impala.dsi.core.impl.DSIDriver;
import com.cloudera.impala.dsi.dataengine.filters.IFilter;
import com.cloudera.impala.dsi.dataengine.filters.IdentifierFilter;
import com.cloudera.impala.dsi.dataengine.filters.SmallIntFilter;
import com.cloudera.impala.dsi.dataengine.filters.StringFilter;
import com.cloudera.impala.dsi.dataengine.filters.StringListFilter;
import com.cloudera.impala.dsi.dataengine.filters.StringPatternFilter;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.impala.dsi.utilities.DSIMessageKey;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.ExceptionType;
import java.util.List;
import java.util.Map;

public class DSIMetadataFilterFactory {
    private final boolean m_caseInsensitiveSearch;
    private boolean m_performFiltering;

    public DSIMetadataFilterFactory(boolean bl, boolean bl2) {
        this.m_performFiltering = bl;
        this.m_caseInsensitiveSearch = bl2;
    }

    public DSIMetadataFilterFactory(boolean bl) {
        this(bl, false);
    }

    public void createFilters(MetadataSourceID metadataSourceID, List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        switch (metadataSourceID) {
            case CATALOG_SCHEMA_ONLY: {
                this.createCatalogSchemaOnlyFilters(list, string, string2, bl, list2, map);
                break;
            }
            case COLUMN_PRIVILEGES: {
                this.createColumnPrivilegesFilters(list, string, string2, bl, list2, map);
                break;
            }
            case COLUMNS: 
            case PSEUDO_COLUMNS_JDBC41: {
                this.createColumnsFilters(list, string, string2, bl, list2, map);
                break;
            }
            case FOREIGN_KEYS: {
                this.createForeignKeysFilters(list, string, string2, bl, list2, map);
                break;
            }
            case PRIMARY_KEYS: {
                this.createPrimaryKeysFilters(list, string, string2, bl, list2, map);
                break;
            }
            case PROCEDURE_COLUMNS: 
            case FUNCTION_COLUMNS_JDBC4: {
                this.createProcedureColumnsFilters(list, string, string2, bl, list2, map);
                break;
            }
            case PROCEDURES: 
            case FUNCTIONS_JDBC4: {
                this.createProceduresFilters(list, string, string2, bl, list2, map);
                break;
            }
            case SPECIAL_COLUMNS: {
                this.createSpecialColumnsFilters(list, string, string2, bl, list2, map);
                break;
            }
            case STATISTICS: {
                this.createStatisticsFilters(list, string, string2, bl, list2, map);
                break;
            }
            case TABLE_PRIVILEGES: {
                this.createTablePrivilegesFilters(list, string, string2, bl, list2, map);
                break;
            }
            case CATALOG_ONLY: 
            case SCHEMA_ONLY: 
            case TABLETYPE_ONLY: {
                break;
            }
            case TABLES: {
                this.createTablesFilters(list, string, string2, bl, list2, map);
                break;
            }
            case TYPE_INFO: {
                this.createTypeInfoFilters(list, list2, map);
                break;
            }
            default: {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), metadataSourceID.toString(), ExceptionType.DEFAULT);
            }
        }
    }

    private void addRestriction(String string, MetadataSourceColumnTag metadataSourceColumnTag, Map<MetadataSourceColumnTag, String> map) {
        if (null != string) {
            map.put(metadataSourceColumnTag, string);
        }
    }

    private void addRestriction(StringPatternFilter stringPatternFilter, String string, MetadataSourceColumnTag metadataSourceColumnTag, Map<MetadataSourceColumnTag, String> map) {
        if (!(null == string || this.m_performFiltering && stringPatternFilter.hasPatternFilter())) {
            map.put(metadataSourceColumnTag, string);
        }
    }

    private void createCatalogSchemaOnlyFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (2 <= list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string2, list2, map);
        } else {
            this.createPatternFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string, list2, map);
        }
    }

    private void createColumnPrivilegesFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (4 == list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.COLUMN_NAME, list.get(3), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.COLUMN_NAME, list.get(3), string, list2, map);
        }
    }

    private void createColumnsFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (4 == list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.COLUMN_NAME, list.get(3), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.COLUMN_NAME, list.get(3), string, list2, map);
        }
    }

    private void createForeignKeysFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (6 == list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME, list.get(2), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME, list.get(3), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME, list.get(4), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME, list.get(5), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, list.get(0), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, list.get(1), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME, list.get(2), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME, list.get(3), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME, list.get(4), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME, list.get(5), list2, map);
        }
    }

    private void createIdentifierFilter(MetadataSourceColumnTag metadataSourceColumnTag, String string, String string2, List<IFilter> list, Map<MetadataSourceColumnTag, String> map) {
        list.add(new IdentifierFilter(metadataSourceColumnTag, string, string2));
        this.addRestriction(string, metadataSourceColumnTag, map);
    }

    private void createPatternFilter(MetadataSourceColumnTag metadataSourceColumnTag, String string, String string2, List<IFilter> list, Map<MetadataSourceColumnTag, String> map) {
        StringPatternFilter stringPatternFilter = new StringPatternFilter(metadataSourceColumnTag, string, string2, this.m_caseInsensitiveSearch);
        list.add(stringPatternFilter);
        this.addRestriction(stringPatternFilter, string, metadataSourceColumnTag, map);
    }

    private void createPrimaryKeysFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (3 == list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME, list.get(2), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, list.get(0), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, list.get(1), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME, list.get(2), list2, map);
        }
    }

    private void createProcedureColumnsFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (4 == list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.PROCEDURE_NAME, list.get(2), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.COLUMN_NAME, list.get(3), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.PROCEDURE_NAME, list.get(2), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.COLUMN_NAME, list.get(3), string, list2, map);
        }
    }

    private void createProceduresFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (3 == list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.PROCEDURE_NAME, list.get(2), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.PROCEDURE_NAME, list.get(2), string, list2, map);
        }
    }

    private void createSpecialColumnsFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (4 <= list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(2), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(3), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(1), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(2), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(3), list2, map);
        }
        list2.add(new SmallIntFilter(MetadataSourceColumnTag.SCOPE, list.get(4)));
        this.addRestriction(list.get(4), MetadataSourceColumnTag.SCOPE, map);
        this.addRestriction(list.get(0), MetadataSourceColumnTag.IDENTIFIER_TYPE_TAG, map);
        this.addRestriction(list.get(5), MetadataSourceColumnTag.NULLABLE_TAG, map);
    }

    private void createStatisticsFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (3 <= list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), list2, map);
            this.createStringFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), list2, map);
        }
        this.addRestriction(list.get(3), MetadataSourceColumnTag.UNIQUE_TAG, map);
        this.addRestriction(list.get(4), MetadataSourceColumnTag.RESERVED_TAG, map);
    }

    private void createStringFilter(MetadataSourceColumnTag metadataSourceColumnTag, String string, List<IFilter> list, Map<MetadataSourceColumnTag, String> map) {
        list.add(new StringFilter(metadataSourceColumnTag, string, this.m_caseInsensitiveSearch));
        this.addRestriction(string, metadataSourceColumnTag, map);
    }

    private void createTablePrivilegesFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (3 == list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), string2, list2, map);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), string, list2, map);
        }
    }

    private void createTablesFilters(List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (4 == list.size());
        if (bl) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string2, list2, map);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), string2, list2, map);
        } else {
            this.createPatternFilter(MetadataSourceColumnTag.CATALOG_NAME, list.get(0), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, list.get(1), string, list2, map);
            this.createPatternFilter(MetadataSourceColumnTag.TABLE_NAME, list.get(2), string, list2, map);
        }
        if (this.m_performFiltering) {
            list2.add(new StringListFilter(MetadataSourceColumnTag.TABLE_TYPE, list.get(3)));
        } else {
            this.createStringFilter(MetadataSourceColumnTag.TABLE_TYPE, list.get(3), list2, map);
        }
    }

    private void createTypeInfoFilters(List<String> list, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) {
        assert (1 == list.size());
        String string = list.get(0);
        if (null == string) {
            return;
        }
        if (!string.equals("0")) {
            list2.add(new SmallIntFilter(MetadataSourceColumnTag.DATA_TYPE, string));
            this.addRestriction(list.get(0), MetadataSourceColumnTag.DATA_TYPE, map);
        }
    }
}

