/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import javax.servlet.http.HttpSession;
import org.springframework.lang.Nullable;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public class SharedHttpSessionConfigurer
implements MockMvcConfigurer {
    @Nullable
    private HttpSession session;

    @Override
    public void afterConfigurerAdded(ConfigurableMockMvcBuilder<?> builder) {
        builder.alwaysDo(result -> {
            this.session = result.getRequest().getSession(false);
        });
    }

    @Override
    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        return request2 -> {
            if (this.session != null) {
                request2.setSession(this.session);
            }
            return request2;
        };
    }

    public static SharedHttpSessionConfigurer sharedHttpSession() {
        return new SharedHttpSessionConfigurer();
    }
}

