/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ProtectedConstructorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ProtectedConstructorCallChecker
implements CallChecker {
    @NotNull
    public static final ProtectedConstructorCallChecker INSTANCE = new ProtectedConstructorCallChecker();

    private ProtectedConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        ConstructorDescriptor actualConstructor;
        DeclarationDescriptor scopeOwner;
        ConstructorDescriptor descriptor2;
        block7: {
            Object object;
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor;
            ConstructorDescriptor constructorDescriptor;
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Object object2 = resolvedCall2.getResultingDescriptor();
            ConstructorDescriptor constructorDescriptor2 = constructorDescriptor = object2 instanceof ConstructorDescriptor ? (ConstructorDescriptor)object2 : null;
            if (constructorDescriptor == null) {
                return;
            }
            descriptor2 = constructorDescriptor;
            object2 = descriptor2.getContainingDeclaration().getOriginal();
            Intrinsics.checkNotNullExpressionValue(object2, (String)"descriptor.containingDeclaration.original");
            Object constructorOwner = object2;
            scopeOwner = context2.getScope().getOwnerDescriptor();
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor2 = typeAliasConstructorDescriptor = descriptor2 instanceof TypeAliasConstructorDescriptor ? (TypeAliasConstructorDescriptor)descriptor2 : null;
            ConstructorDescriptor constructorDescriptor3 = typeAliasConstructorDescriptor == null ? descriptor2 : (actualConstructor = (object = typeAliasConstructorDescriptor.getUnderlyingConstructorDescriptor()) == null ? descriptor2 : (ConstructorDescriptor)object);
            if (!Intrinsics.areEqual((Object)actualConstructor.getVisibility().normalize(), (Object)DescriptorVisibilities.PROTECTED)) {
                return;
            }
            if (!DescriptorVisibilities.isVisibleWithAnyReceiver(descriptor2, scopeOwner)) {
                return;
            }
            KtExpression calleeExpression = resolvedCall2.getCall().getCalleeExpression();
            object = calleeExpression;
            if (object instanceof KtConstructorCalleeExpression ? ((KtConstructorCalleeExpression)calleeExpression).getParent() instanceof KtSuperTypeCallEntry : object instanceof KtConstructorDelegationReferenceExpression) {
                return;
            }
            Sequence<DeclarationDescriptor> $this$any$iv = DescriptorUtilsKt.getParentsWithSelf(scopeOwner);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl2 = false;
                if (!(it.getOriginal() == constructorOwner)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        if (Intrinsics.areEqual((Object)DescriptorVisibilities.findInvisibleMember(DescriptorVisibilities.FALSE_IF_PROTECTED, descriptor2, scopeOwner), (Object)actualConstructor.getOriginal())) {
            context2.getTrace().report(Errors.PROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL.on(reportOn, descriptor2));
        }
    }
}

