/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnSealedClassExhaustivenessChecker;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J)\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "processExhaustivenessCheck", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformWhenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Companion", "resolve"})
public final class FirWhenExhaustivenessTransformer
extends FirTransformer<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    public FirWhenExhaustivenessTransformer(@NotNull BodyResolveComponents bodyResolveComponents) {
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        this.bodyResolveComponents = bodyResolveComponents;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        throw new IllegalArgumentException("Should not be there");
    }

    @Override
    @NotNull
    public FirStatement transformWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        this.processExhaustivenessCheck(whenExpression);
        return whenExpression;
    }

    private final void processExhaustivenessCheck(FirWhenExpression whenExpression) {
        Object object;
        ConeKotlinType $i$f$any2;
        boolean bl;
        FirPureAbstractElement it2;
        Object element$iv2;
        boolean bl2;
        block12: {
            Iterable $this$any$iv = whenExpression.getBranches();
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    it2 = (FirWhenBranch)element$iv2;
                    bl = false;
                    if (!(it2.getCondition() instanceof FirElseIfTrueCondition)) continue;
                    bl2 = true;
                    break block12;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.Exhaustive.INSTANCE);
            return;
        }
        FirVariable<?> firVariable = whenExpression.getSubjectVariable();
        ConeKotlinType coneKotlinType = firVariable == null ? null : ($i$f$any2 = (element$iv2 = firVariable.getReturnTypeRef()) == null ? null : FirTypeUtilsKt.getConeType(element$iv2));
        if ($i$f$any2 == null) {
            element$iv2 = whenExpression.getSubject();
            Object object2 = element$iv2 == null ? null : (firVariable = (it2 = ((FirExpression)element$iv2).getTypeRef()) == null ? null : FirTypeUtilsKt.getConeType((FirTypeRef)it2));
            if (firVariable == null) {
                element$iv2 = this;
                boolean it2 = false;
                bl = false;
                FirWhenExhaustivenessTransformer $this$processExhaustivenessCheck_u24lambda_u2d1 = (FirWhenExhaustivenessTransformer)element$iv2;
                boolean bl3 = false;
                whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH());
                return;
            }
            object = firVariable;
        } else {
            object = $i$f$any2;
        }
        ConeKotlinType subjectType = object;
        FirSession session2 = this.bodyResolveComponents.getSession();
        ConeKotlinType cleanSubjectType = ConeTypesKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType(subjectType, session2));
        boolean it2 = false;
        bl = false;
        bl = false;
        List $this$processExhaustivenessCheck_u24lambda_u2d1 = CollectionsKt.createListBuilder();
        boolean bl4 = false;
        boolean bl5 = false;
        List $this$processExhaustivenessCheck_u24lambda_u2d3 = $this$processExhaustivenessCheck_u24lambda_u2d1;
        boolean bl6 = false;
        Iterable $this$filterTo$iv = exhaustivenessCheckers;
        boolean $i$f$filterTo = false;
        for (Object element$iv3 : $this$filterTo$iv) {
            WhenExhaustivenessChecker it3 = (WhenExhaustivenessChecker)element$iv3;
            boolean bl7 = false;
            if (!it3.isApplicable(cleanSubjectType, session2)) continue;
            ((Collection)$this$processExhaustivenessCheck_u24lambda_u2d3).add(element$iv3);
        }
        Collection collection = $this$processExhaustivenessCheck_u24lambda_u2d3;
        boolean bl8 = false;
        if (!collection.isEmpty() && ConeTypeUtilsKt.isMarkedNullable(cleanSubjectType)) {
            $this$processExhaustivenessCheck_u24lambda_u2d3.add(WhenOnNullableExhaustivenessChecker.INSTANCE);
        }
        List checkers = CollectionsKt.build((List)$this$processExhaustivenessCheck_u24lambda_u2d1);
        if (checkers.isEmpty()) {
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH());
            return;
        }
        bl = false;
        List whenMissingCases = new ArrayList();
        for (WhenExhaustivenessChecker checker : checkers) {
            checker.computeMissingCases(whenExpression, cleanSubjectType, session2, whenMissingCases);
        }
        if (whenMissingCases.isEmpty() && whenExpression.getBranches().isEmpty()) {
            whenMissingCases.add(WhenMissingCase.Unknown.INSTANCE);
        }
        ExhaustivenessStatus status2 = whenMissingCases.isEmpty() ? (ExhaustivenessStatus)ExhaustivenessStatus.Exhaustive.INSTANCE : (ExhaustivenessStatus)new ExhaustivenessStatus.NotExhaustive(whenMissingCases);
        whenExpression.replaceExhaustivenessStatus(status2);
    }

    static {
        Object[] objectArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedClassExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion;", "", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

