/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u0013*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J,\u0010\u001d\u001a\u00020\u0013*\u00020\u00162\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u001fj\b\u0012\u0004\u0012\u00020\u0016` 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010\u001d\u001a\u00020\u0013*\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u0013*\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010%\u001a\u00020\u0013*\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "cloneableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "javaLangFqName", "reservedFunctionNames", "", "", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isCloneableId", "", "Lorg/jetbrains/kotlin/name/ClassId;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isInapplicableParameterType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isNotFinalReadOnly", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "primaryConstructorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isRecursiveInlineClassType", "visited", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isRelatedToParameter", "parameter", "isSubtypeOfCloneable", "checkers"})
public final class FirInlineClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirInlineClassDeclarationChecker INSTANCE = new FirInlineClassDeclarationChecker();
    @NotNull
    private static final Set<String> reservedFunctionNames;
    @NotNull
    private static final FqName javaLangFqName;
    @NotNull
    private static final FqName cloneableFqName;

    private FirInlineClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        List<String> list2;
        FirAnnotationContainer firAnnotationContainer;
        FirSourceElement firSourceElement;
        FirElement firElement;
        Object $this$isInterface$iv;
        block62: {
            block61: {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (!FirDeclarationCheckerUtilsKt.isInlineOrValueClass(declaration2)) {
                    return;
                }
                FirRegularClass $this$isInner$iv = declaration2;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block61;
                FirClassLikeDeclaration $this$isLocal$iv = declaration2;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block62;
            }
            DiagnosticReporterKt.reportOn(reporter, declaration2.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_NOT_TOP_LEVEL(), context2);
        }
        FirRegularClass $this$modality$iv = declaration2;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
            DiagnosticReporterKt.reportOn(reporter, declaration2.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_NOT_FINAL(), context2);
        }
        for (FirTypeRef supertypeEntry : declaration2.getSuperTypeRefs()) {
            Boolean bl;
            FirRegularClass firRegularClass = FirHelpersKt.toRegularClass(supertypeEntry, context2.getSession());
            if (firRegularClass == null) {
                bl = null;
            } else {
                $this$isInterface$iv = firRegularClass;
                boolean $i$f$isInterface = false;
                bl = ((FirRegularClass)$this$isInterface$iv).getClassKind() == ClassKind.INTERFACE;
            }
            if (Intrinsics.areEqual(bl, (Object)true)) continue;
            DiagnosticReporterKt.reportOnWithSuppression(reporter, supertypeEntry, FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_EXTEND_CLASSES(), context2);
        }
        if (this.isSubtypeOfCloneable(declaration2, context2.getSession())) {
            DiagnosticReporterKt.reportOn(reporter, declaration2.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_CLONEABLE(), context2);
        }
        FirConstructor primaryConstructor2 = null;
        Object primaryConstructorParameter = null;
        FirDeclaration primaryConstructorProperty = null;
        for (FirDeclaration innerDeclaration : declaration2.getDeclarations()) {
            FirSourceElement firSourceElement2;
            List<String> arguments$iv;
            boolean bl;
            FirAnnotationContainer firAnnotationContainer2;
            firElement = innerDeclaration;
            if (firElement instanceof FirConstructor) {
                List<String> list3;
                if (((FirConstructor)innerDeclaration).isPrimary()) {
                    primaryConstructor2 = (FirConstructor)innerDeclaration;
                    primaryConstructorParameter = CollectionsKt.singleOrNull(((FirConstructor)innerDeclaration).getValueParameters());
                    continue;
                }
                if (((FirConstructor)innerDeclaration).getBody() == null) continue;
                FirBlock firBlock = ((FirConstructor)innerDeclaration).getBody();
                Intrinsics.checkNotNull((Object)firBlock);
                FirBlock body2 = firBlock;
                boolean $i$f$withSuppressedDiagnostics = false;
                FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer2 = (FirElement)innerDeclaration instanceof FirAnnotationContainer ? (FirAnnotationContainer)((Object)innerDeclaration) : null;
                if (firAnnotationContainer2 == null) {
                    list3 = null;
                } else {
                    FirAnnotationContainer firAnnotationContainer4 = firAnnotationContainer2;
                    bl = false;
                    boolean bl2 = false;
                    FirAnnotationContainer it$iv = firAnnotationContainer4;
                    boolean bl3 = false;
                    list3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                arguments$iv = list3;
                if (arguments$iv != null) {
                    CheckerContext context3 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    boolean bl4 = false;
                    DiagnosticReporterKt.reportOnWithSuppression(reporter, body2, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_INLINE_CLASS(), context3);
                    continue;
                }
                CheckerContext context4 = context2;
                boolean bl5 = false;
                DiagnosticReporterKt.reportOnWithSuppression(reporter, body2, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_INLINE_CLASS(), context4);
                continue;
            }
            if (firElement instanceof FirRegularClass) {
                FirRegularClass $this$isInner$iv = (FirRegularClass)innerDeclaration;
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) continue;
                DiagnosticReporterKt.reportOnWithSuppression(reporter, innerDeclaration, FirErrors.INSTANCE.getINNER_CLASS_INSIDE_INLINE_CLASS(), context2);
                continue;
            }
            if (firElement instanceof FirSimpleFunction) {
                String $i$f$isInner = ((FirSimpleFunction)innerDeclaration).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$isInner, (String)"innerDeclaration.name.asString()");
                String functionName = $i$f$isInner;
                if (!reservedFunctionNames.contains(functionName)) continue;
                DiagnosticReporterKt.reportOnWithSuppression(reporter, innerDeclaration, FirErrors.INSTANCE.getRESERVED_MEMBER_INSIDE_INLINE_CLASS(), functionName, context2);
                continue;
            }
            if (firElement instanceof FirField) {
                List<String> list4;
                FirDeclaration $this$isSynthetic$iv = innerDeclaration;
                boolean $i$f$isSynthetic22 = false;
                if (!Intrinsics.areEqual((Object)$this$isSynthetic$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) continue;
                FirTypeRef $i$f$isSynthetic22 = ((FirResolvedTypeRef)((FirField)innerDeclaration).getReturnTypeRef()).getDelegatedTypeRef();
                FirSourceElement delegatedTypeRefSource = $i$f$isSynthetic22 == null ? null : $i$f$isSynthetic22.getSource();
                boolean $i$f$withSuppressedDiagnostics = false;
                FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer2 = (FirElement)innerDeclaration instanceof FirAnnotationContainer ? (FirAnnotationContainer)((Object)innerDeclaration) : null;
                if (firAnnotationContainer2 == null) {
                    list4 = null;
                } else {
                    FirAnnotationContainer firAnnotationContainer6 = firAnnotationContainer2;
                    bl = false;
                    boolean bl6 = false;
                    FirAnnotationContainer it$iv = firAnnotationContainer6;
                    boolean bl7 = false;
                    list4 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                arguments$iv = list4;
                if (arguments$iv != null) {
                    CheckerContext context5 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    boolean bl8 = false;
                    DiagnosticReporterKt.reportOn(reporter, delegatedTypeRefSource, FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), context5);
                    continue;
                }
                CheckerContext context6 = context2;
                boolean bl9 = false;
                DiagnosticReporterKt.reportOn(reporter, delegatedTypeRefSource, FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), context6);
                continue;
            }
            if (!(firElement instanceof FirProperty)) continue;
            if (this.isRelatedToParameter((FirProperty)innerDeclaration, (FirValueParameter)primaryConstructorParameter)) {
                primaryConstructorProperty = innerDeclaration;
                continue;
            }
            if (((FirProperty)innerDeclaration).getDelegate() != null) {
                CheckerContext context7;
                List<String> list5;
                FirAnnotationContainer firAnnotationContainer7;
                boolean $i$f$withSuppressedDiagnostics = false;
                FirAnnotationContainer firAnnotationContainer8 = firAnnotationContainer7 = (FirElement)innerDeclaration instanceof FirAnnotationContainer ? (FirAnnotationContainer)((Object)innerDeclaration) : null;
                if (firAnnotationContainer7 == null) {
                    list5 = null;
                } else {
                    firAnnotationContainer2 = firAnnotationContainer7;
                    boolean bl10 = false;
                    bl = false;
                    FirAnnotationContainer it$iv = firAnnotationContainer2;
                    boolean bl11 = false;
                    list5 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                List<String> arguments$iv2 = list5;
                if (arguments$iv2 != null) {
                    context7 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                    boolean bl12 = false;
                    FirExpression firExpression2 = ((FirProperty)innerDeclaration).getDelegate();
                    Intrinsics.checkNotNull((Object)firExpression2);
                    DiagnosticReporterKt.reportOn(reporter, firExpression2.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_INLINE_CLASS(), context7);
                    continue;
                }
                context7 = context2;
                boolean bl13 = false;
                FirExpression firExpression3 = ((FirProperty)innerDeclaration).getDelegate();
                Intrinsics.checkNotNull((Object)firExpression3);
                DiagnosticReporterKt.reportOn(reporter, firExpression3.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_INLINE_CLASS(), context7);
                continue;
            }
            if (!FirDeclarationUtilKt.getHasBackingField((FirProperty)innerDeclaration) || ((firSourceElement2 = innerDeclaration.getSource()) == null ? null : firSourceElement2.getKind()) instanceof FirFakeSourceElementKind) continue;
            DiagnosticReporterKt.reportOnWithSuppression(reporter, innerDeclaration, FirErrors.INSTANCE.getPROPERTY_WITH_BACKING_FIELD_INSIDE_INLINE_CLASS(), context2);
        }
        $this$isInterface$iv = primaryConstructor2;
        if (!(($this$isInterface$iv == null ? null : ((firSourceElement = ((FirConstructor)$this$isInterface$iv).getSource()) == null ? null : firSourceElement.getKind())) instanceof FirRealSourceElementKind)) {
            DiagnosticReporterKt.reportOn(reporter, declaration2.getSource(), FirErrors.INSTANCE.getABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_INLINE_CLASS(), context2);
            return;
        }
        if (primaryConstructorParameter == null) {
            DiagnosticReporterKt.reportOnWithSuppression(reporter, primaryConstructor2, FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE(), context2);
            return;
        }
        boolean $i$f$withSuppressedDiagnostics = false;
        FirAnnotationContainer firAnnotationContainer9 = firAnnotationContainer = (FirElement)primaryConstructor2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)primaryConstructor2) : null;
        if (firAnnotationContainer == null) {
            list2 = null;
        } else {
            firElement = firAnnotationContainer;
            boolean bl = false;
            boolean bl14 = false;
            FirElement it$iv = firElement;
            boolean bl15 = false;
            list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer((FirAnnotationContainer)it$iv);
        }
        List<String> arguments$iv = list2;
        if (arguments$iv != null) {
            List<String> list6;
            FirAnnotationContainer firAnnotationContainer10;
            CheckerContext context8 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            boolean bl = false;
            FirElement element$iv = (FirElement)primaryConstructorParameter;
            boolean $i$f$withSuppressedDiagnostics2 = false;
            FirAnnotationContainer firAnnotationContainer11 = firAnnotationContainer10 = element$iv instanceof FirAnnotationContainer ? (FirAnnotationContainer)element$iv : null;
            if (firAnnotationContainer10 == null) {
                list6 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer12 = firAnnotationContainer10;
                boolean bl16 = false;
                boolean bl17 = false;
                FirAnnotationContainer it$iv = firAnnotationContainer12;
                boolean bl18 = false;
                list6 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv3 = list6;
            if (arguments$iv3 != null) {
                CheckerContext context9 = context8.addSuppressedDiagnostics((Collection<String>)arguments$iv3, arguments$iv3.contains("infos"), arguments$iv3.contains("warnings"), arguments$iv3.contains("errors"));
                boolean bl19 = false;
                if (INSTANCE.isNotFinalReadOnly((FirValueParameter)primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    DiagnosticReporterKt.reportOn(reporter, ((FirValueParameter)primaryConstructorParameter).getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), context9);
                } else if (INSTANCE.isInapplicableParameterType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef())) {
                    DiagnosticReporterKt.reportOn(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getINLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context9);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context9.getSession())) {
                    DiagnosticReporterKt.reportOnWithSuppression(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef(), FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_BE_RECURSIVE(), context9);
                }
            } else {
                CheckerContext context10 = context8;
                boolean bl20 = false;
                if (INSTANCE.isNotFinalReadOnly((FirValueParameter)primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    DiagnosticReporterKt.reportOn(reporter, ((FirValueParameter)primaryConstructorParameter).getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), context10);
                } else if (INSTANCE.isInapplicableParameterType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef())) {
                    DiagnosticReporterKt.reportOn(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getINLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context10);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context10.getSession())) {
                    DiagnosticReporterKt.reportOnWithSuppression(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef(), FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_BE_RECURSIVE(), context10);
                }
            }
        } else {
            List<String> list7;
            FirAnnotationContainer firAnnotationContainer13;
            CheckerContext context11 = context2;
            boolean bl = false;
            FirElement element$iv = (FirElement)primaryConstructorParameter;
            boolean $i$f$withSuppressedDiagnostics3 = false;
            FirAnnotationContainer firAnnotationContainer14 = firAnnotationContainer13 = element$iv instanceof FirAnnotationContainer ? (FirAnnotationContainer)element$iv : null;
            if (firAnnotationContainer13 == null) {
                list7 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer15 = firAnnotationContainer13;
                boolean bl21 = false;
                boolean bl22 = false;
                FirAnnotationContainer it$iv = firAnnotationContainer15;
                boolean bl23 = false;
                list7 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv4 = list7;
            if (arguments$iv4 != null) {
                CheckerContext context12 = context11.addSuppressedDiagnostics((Collection<String>)arguments$iv4, arguments$iv4.contains("infos"), arguments$iv4.contains("warnings"), arguments$iv4.contains("errors"));
                boolean bl24 = false;
                if (INSTANCE.isNotFinalReadOnly((FirValueParameter)primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    DiagnosticReporterKt.reportOn(reporter, ((FirValueParameter)primaryConstructorParameter).getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), context12);
                } else if (INSTANCE.isInapplicableParameterType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef())) {
                    DiagnosticReporterKt.reportOn(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getINLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context12);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context12.getSession())) {
                    DiagnosticReporterKt.reportOnWithSuppression(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef(), FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_BE_RECURSIVE(), context12);
                }
            } else {
                CheckerContext context13 = context11;
                boolean bl25 = false;
                if (INSTANCE.isNotFinalReadOnly((FirValueParameter)primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    DiagnosticReporterKt.reportOn(reporter, ((FirValueParameter)primaryConstructorParameter).getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), context13);
                } else if (INSTANCE.isInapplicableParameterType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef())) {
                    DiagnosticReporterKt.reportOn(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getINLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context13);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(((FirValueParameter)primaryConstructorParameter).getReturnTypeRef()), context13.getSession())) {
                    DiagnosticReporterKt.reportOnWithSuppression(reporter, ((FirValueParameter)primaryConstructorParameter).getReturnTypeRef(), FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_BE_RECURSIVE(), context13);
                }
            }
        }
    }

    private final boolean isRelatedToParameter(FirProperty $this$isRelatedToParameter, FirValueParameter parameter) {
        Object object;
        return Intrinsics.areEqual((Object)$this$isRelatedToParameter.getName(), (Object)((object = parameter) == null ? null : ((FirValueParameter)object).getName())) && ((object = $this$isRelatedToParameter.getSource()) == null ? null : ((FirSourceElement)object).getKind()) instanceof FirFakeSourceElementKind;
    }

    private final boolean isNotFinalReadOnly(FirValueParameter $this$isNotFinalReadOnly, FirProperty primaryConstructorProperty) {
        if (primaryConstructorProperty == null) {
            return true;
        }
        FirElement firElement = $this$isNotFinalReadOnly;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OPEN_KEYWORD");
        boolean isOpen = FirModifierUtilsKt.hasModifier(firElement, ktModifierKeywordToken);
        return $this$isNotFinalReadOnly.isVararg() || !primaryConstructorProperty.isVal() || isOpen;
    }

    private final boolean isInapplicableParameterType(FirTypeRef $this$isInapplicableParameterType) {
        return FirTypeUtilsKt.isUnit($this$isInapplicableParameterType) || FirTypeUtilsKt.isNothing($this$isInapplicableParameterType) || FirTypeUtilsKt.getConeType($this$isInapplicableParameterType) instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(FirTypeUtilsKt.getConeType($this$isInapplicableParameterType));
    }

    private final boolean isGenericArrayOfTypeParameter(ConeKotlinType $this$isGenericArrayOfTypeParameter) {
        ConeKotlinType coneKotlinType;
        if (ArraysKt.firstOrNull((Object[])$this$isGenericArrayOfTypeParameter.getTypeArguments()) instanceof ConeStarProjection || !CallableReferenceResolutionKt.isPotentiallyArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        ConeKotlinType coneKotlinType2 = ArrayUtilsKt.arrayElementType($this$isGenericArrayOfTypeParameter);
        ConeKotlinType coneKotlinType3 = coneKotlinType = coneKotlinType2 == null ? null : coneKotlinType2.getType();
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType arrayElementType = coneKotlinType;
        return arrayElementType instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(arrayElementType);
    }

    private final boolean isRecursiveInlineClassType(ConeKotlinType $this$isRecursiveInlineClassType, FirSession session2) {
        boolean bl = false;
        return this.isRecursiveInlineClassType($this$isRecursiveInlineClassType, new HashSet<ConeKotlinType>(), session2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRecursiveInlineClassType(ConeKotlinType $this$isRecursiveInlineClassType, HashSet<ConeKotlinType> visited2, FirSession session2) {
        ConeKotlinType coneKotlinType;
        Object object;
        if (!visited2.add($this$isRecursiveInlineClassType)) {
            return true;
        }
        FirRegularClass firRegularClass = FirHelpersKt.toRegularClass($this$isRecursiveInlineClassType, session2);
        if (firRegularClass == null) {
            return false;
        }
        FirRegularClass asRegularClass = firRegularClass;
        if (!FirDeclarationCheckerUtilsKt.isInlineOrValueClass(asRegularClass)) return false;
        FirPureAbstractElement firPureAbstractElement = FirDeclarationUtilKt.getPrimaryConstructor(asRegularClass);
        if (firPureAbstractElement == null) {
            object = null;
        } else {
            FirConstructor firConstructor = firPureAbstractElement;
            boolean bl = false;
            boolean bl2 = false;
            FirConstructor it = firConstructor;
            boolean bl3 = false;
            FirSourceElement firSourceElement = it.getSource();
            FirConstructor firConstructor2 = (firSourceElement == null ? null : firSourceElement.getKind()) instanceof FirRealSourceElementKind ? firConstructor : null;
            object = coneKotlinType = firConstructor2 == null ? null : firConstructor2.getValueParameters();
        }
        FirPureAbstractElement firPureAbstractElement2 = coneKotlinType == null ? null : (firRegularClass = (firPureAbstractElement = (FirValueParameter)CollectionsKt.firstOrNull(coneKotlinType)) == null ? null : ((FirValueParameter)firPureAbstractElement).getReturnTypeRef());
        if (!Intrinsics.areEqual(firRegularClass == null ? null : ((coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)((Object)firRegularClass))) == null ? null : Boolean.valueOf(this.isRecursiveInlineClassType(coneKotlinType, visited2, session2))), (Object)true)) return false;
        return true;
    }

    private final boolean isSubtypeOfCloneable(FirRegularClass $this$isSubtypeOfCloneable, FirSession session2) {
        boolean bl;
        block4: {
            if (this.isCloneableId(FirDeclarationUtilKt.getClassId($this$isSubtypeOfCloneable))) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubtypeOfCloneable, true, true, session2, null, false, 48, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType coneClassLikeType;
                    ConeClassLikeLookupTag coneClassLikeLookupTag;
                    Object object;
                    ConeClassLikeType superType = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    Object object2 = object = superType instanceof ConeClassLikeType ? superType : null;
                    ConeClassLikeLookupTag coneClassLikeLookupTag2 = object == null ? null : (coneClassLikeLookupTag = (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)object, session2, null, 2, null)) == null ? null : coneClassLikeType.getLookupTag());
                    if (!Intrinsics.areEqual(coneClassLikeLookupTag == null ? null : ((object = coneClassLikeLookupTag.getClassId()) == null ? null : Boolean.valueOf(INSTANCE.isCloneableId((ClassId)object))), (Object)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCloneableId(ClassId $this$isCloneableId) {
        return Intrinsics.areEqual((Object)$this$isCloneableId.getRelativeClassName(), (Object)cloneableFqName) && Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || Intrinsics.areEqual((Object)$this$isCloneableId.getPackageFqName(), (Object)javaLangFqName);
    }

    static {
        Object[] objectArray = new String[]{"box", "unbox", "equals", "hashCode"};
        reservedFunctionNames = SetsKt.setOf((Object[])objectArray);
        javaLangFqName = new FqName("java.lang");
        cloneableFqName = new FqName("Cloneable");
    }
}

