/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRendererUtilKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00050\u0004B-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ-\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticWithParameters2Renderer;", "A", "", "B", "Lorg/jetbrains/kotlin/diagnostics/rendering/AbstractDiagnosticWithParametersRenderer;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticWithParameters2;", "message", "", "rendererForA", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "rendererForB", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;)V", "renderParameters", "", "diagnostic", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticWithParameters2;)[Ljava/lang/Object;", "frontend"})
public final class DiagnosticWithParameters2Renderer<A, B>
extends AbstractDiagnosticWithParametersRenderer<DiagnosticWithParameters2<?, A, B>> {
    @Nullable
    private final DiagnosticParameterRenderer<A> rendererForA;
    @Nullable
    private final DiagnosticParameterRenderer<B> rendererForB;

    public DiagnosticWithParameters2Renderer(@NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererForA, @Nullable DiagnosticParameterRenderer<? super B> rendererForB) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        super(message2);
        this.rendererForA = rendererForA;
        this.rendererForB = rendererForB;
    }

    @Override
    @NotNull
    public Object[] renderParameters(@NotNull DiagnosticWithParameters2<?, A, B> diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
        Object[] objectArray = new Object[]{diagnostic.getA(), diagnostic.getB()};
        RenderingContext context2 = RenderingContext.Companion.of(objectArray);
        objectArray = new Object[2];
        Object object = diagnostic.getA();
        Intrinsics.checkNotNullExpressionValue(object, (String)"diagnostic.a");
        objectArray[0] = DiagnosticRendererUtilKt.renderParameter(object, this.rendererForA, context2);
        object = diagnostic.getB();
        Intrinsics.checkNotNullExpressionValue(object, (String)"diagnostic.b");
        objectArray[1] = DiagnosticRendererUtilKt.renderParameter(object, this.rendererForB, context2);
        return objectArray;
    }
}

