/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.ExternallyDefinedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordComponent;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordHeader;
import org.jetbrains.kotlin.com.intellij.psi.SyntheticElement;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightMethod;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiExtensibleClass;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final Ref<Pair<Long, Interner<PsiMember>>> myInterner;

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(0);
        }
        this.myInterner = Ref.create();
        this.myClass = aClass;
    }

    public PsiMethod @NotNull [] getConstructors() {
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, PsiImplUtil::getConstructors));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    public PsiField @NotNull [] getFields() {
        PsiField[] psiFieldArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.calcFields()));
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(2);
        }
        return psiFieldArray;
    }

    public PsiMethod @NotNull [] getMethods() {
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.calcMethods()));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    public PsiClass @NotNull [] getInnerClasses() {
        PsiClass[] psiClassArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.calcInnerClasses()));
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    public PsiRecordComponent @NotNull [] getRecordComponents() {
        PsiRecordComponent[] psiRecordComponentArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.calcRecordComponents()));
        if (psiRecordComponentArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(5);
        }
        return psiRecordComponentArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name, true);
        }
        return (PsiField)CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.getFieldsMap()).get(name);
    }

    public PsiMethod @NotNull [] findMethodsByName(String name, boolean checkBases) {
        if (checkBases) {
            PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name, true);
            if (psiMethodArray == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy(ObjectUtils.notNull((PsiMethod[])CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.getMethodsMap()).get(name), PsiMethod.EMPTY_ARRAY));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name, true);
        }
        return (PsiClass)CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.getInnerClassesMap()).get(name);
    }

    @Nullable
    PsiMethod getValuesMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? this.internMember(CachedValuesManager.getProjectPsiDependentCache(this.myClass, ClassInnerStuffCache::makeValuesMethod)) : null;
    }

    @Nullable
    private PsiMethod getValueOfMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? this.internMember(CachedValuesManager.getProjectPsiDependentCache(this.myClass, ClassInnerStuffCache::makeValueOfMethod)) : null;
    }

    private boolean isAnonymousClass() {
        return this.myClass.getName() == null || this.myClass instanceof PsiAnonymousClass;
    }

    private static <T> T[] copy(T[] value2) {
        return value2.length == 0 ? value2 : (Object[])value2.clone();
    }

    private PsiField @NotNull [] calcFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List<PsiField> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiField.class, null));
        PsiField[] psiFieldArray = ArrayUtil.mergeCollections(own, ext, PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @NotNull
    private <T extends PsiMember> List<T> internMembers(List<T> members) {
        List<PsiMember> list2 = ContainerUtil.map(members, this::internMember);
        if (list2 == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(9);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PsiMember> T internMember(T m) {
        if (m == null) {
            return null;
        }
        long modCount = this.myClass.getManager().getModificationTracker().getModificationCount();
        Ref<Pair<Long, Interner<PsiMember>>> ref = this.myInterner;
        synchronized (ref) {
            Pair<Long, Interner<PsiMember>> pair = this.myInterner.get();
            if (pair == null || (Long)pair.first != modCount) {
                pair = Pair.create(modCount, Interner.createWeakInterner());
                this.myInterner.set(pair);
            }
            return ((Interner)pair.second).intern(m);
        }
    }

    private PsiMethod @NotNull [] calcMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List<PsiMethod> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class, null));
        if (this.myClass.isEnum()) {
            ext = new ArrayList<PsiMethod>(ext);
            ContainerUtil.addIfNotNull(ext, this.getValuesMethod());
            ContainerUtil.addIfNotNull(ext, this.getValueOfMethod());
        }
        PsiMethod[] psiMethodArray = ArrayUtil.mergeCollections(own, ext, PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    private PsiClass @NotNull [] calcInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List<PsiClass> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class, null));
        PsiClass[] psiClassArray = ArrayUtil.mergeCollections(own, ext, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    private PsiRecordComponent @NotNull [] calcRecordComponents() {
        PsiRecordHeader header = this.myClass.getRecordHeader();
        PsiRecordComponent[] psiRecordComponentArray = header == null ? PsiRecordComponent.EMPTY_ARRAY : header.getRecordComponents();
        if (psiRecordComponentArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(12);
        }
        return psiRecordComponentArray;
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        THashMap cachedFields = new THashMap();
        for (PsiField field : this.myClass.getOwnFields()) {
            String name = field.getName();
            if (cachedFields.containsKey(name)) continue;
            cachedFields.put(name, field);
        }
        ConcurrentMap<String, PsiField> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> this.lambda$getFieldsMap$7((Map)cachedFields, arg_0));
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(13);
        }
        return concurrentMap;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        List<PsiMethod> ownMethods2 = this.myClass.getOwnMethods();
        ConcurrentMap<String, PsiMethod[]> concurrentMap = ConcurrentFactoryMap.createMap(name -> JBIterable.from(ownMethods2).filter(m -> name.equals(m.getName())).append("values".equals(name) ? this.getValuesMethod() : null).append("valueOf".equals(name) ? this.getValueOfMethod() : null).append((PsiMethod)((Object)this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class, name)))).toArray(PsiMethod.EMPTY_ARRAY));
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(14);
        }
        return concurrentMap;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : this.myClass.getOwnInnerClasses()) {
            String name = psiClass.getName();
            if (name == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error(psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name)) continue;
            cachedInners.put(name, psiClass);
        }
        ConcurrentMap<String, PsiClass> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> this.lambda$getInnerClassesMap$10((Map)cachedInners, arg_0));
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(15);
        }
        return concurrentMap;
    }

    private static PsiMethod makeValuesMethod(PsiExtensibleClass enumClass2) {
        return new EnumSyntheticMethod(enumClass2, "public static " + enumClass2.getName() + "[] values() { }");
    }

    private static PsiMethod makeValueOfMethod(PsiExtensibleClass enumClass2) {
        return new EnumSyntheticMethod(enumClass2, "public static " + enumClass2.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public void dropCaches() {
    }

    private /* synthetic */ PsiClass lambda$getInnerClassesMap$10(Map cachedInners, String name) {
        PsiClass result2 = (PsiClass)cachedInners.get(name);
        return result2 != null ? result2 : this.internMember(ContainerUtil.getFirstItem(PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class, name)));
    }

    private /* synthetic */ PsiField lambda$getFieldsMap$7(Map cachedFields, String name) {
        PsiField result2 = (PsiField)cachedFields.get(name);
        return result2 != null ? result2 : this.internMember(ContainerUtil.getFirstItem(PsiAugmentProvider.collectAugments(this.myClass, PsiField.class, name)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "internMembers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInnerClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRecordComponents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnumSyntheticMethod
    extends LightMethod
    implements SyntheticElement {
        private final PsiClass myClass;
        private final String myText;

        EnumSyntheticMethod(@NotNull PsiClass enumClass2, @NotNull String text2) {
            if (enumClass2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(1);
            }
            super(enumClass2.getManager(), JavaPsiFacade.getElementFactory(enumClass2.getProject()).createMethodFromText(text2, enumClass2), enumClass2);
            this.myClass = enumClass2;
            this.myText = text2;
        }

        @Override
        public int getTextOffset() {
            return this.myClass.getTextOffset();
        }

        public boolean equals(Object another) {
            return this == another || another instanceof EnumSyntheticMethod && this.myClass.equals(((EnumSyntheticMethod)another).myClass) && this.myText.equals(((EnumSyntheticMethod)another).myText);
        }

        public int hashCode() {
            return Objects.hash(this.myText, this.myClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "enumClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/ClassInnerStuffCache$EnumSyntheticMethod";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

