/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.MethodInlinerUtilKt;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0002\u0010\u0011J/\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "isDeadLineNumber", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/LineNumberNode;", "index", "", "frames", "", "", "(Lorg/jetbrains/org/objectweb/asm/tree/LineNumberNode;I[Ljava/lang/Object;)Z", "removeDeadCodeByFrames", "Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer$Result;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;[Ljava/lang/Object;)Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer$Result;", "shouldRemove", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;I[Ljava/lang/Object;)Z", "transform", "", "internalClassName", "", "transformWithResult", "Result", "backend"})
public final class DeadCodeEliminationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        this.transformWithResult(internalClassName, methodNode);
    }

    @NotNull
    public final Result transformWithResult(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Object[] objectArray = MethodTransformer.analyze(internalClassName, methodNode, new OptimizationBasicInterpreter());
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"analyze(internalClassName, methodNode, OptimizationBasicInterpreter())");
        Object[] frames2 = objectArray;
        return this.removeDeadCodeByFrames(methodNode, frames2);
    }

    @NotNull
    public final Result removeDeadCodeByFrames(@NotNull MethodNode methodNode, @NotNull Object[] frames2) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)frames2, (String)"frames");
        ArrayList<AbstractInsnNode> insnsToRemove = new ArrayList<AbstractInsnNode>();
        AbstractInsnNode[] insns = methodNode.instructions.toArray();
        int n = 0;
        int n2 = insns.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                AbstractInsnNode insn = insns[i];
                Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                if (!this.shouldRemove(insn, i, frames2)) continue;
                insnsToRemove.add(insn);
            } while (n <= n2);
        }
        MethodInlinerUtilKt.remove(methodNode, (Collection<? extends AbstractInsnNode>)insnsToRemove);
        UtilKt.removeEmptyCatchBlocks(methodNode);
        return new Result(CollectionsKt.toSet((Iterable)insnsToRemove));
    }

    private final boolean shouldRemove(AbstractInsnNode insn, int index2, Object[] frames2) {
        AbstractInsnNode abstractInsnNode = insn;
        return abstractInsnNode instanceof LabelNode ? false : (abstractInsnNode instanceof LineNumberNode ? this.isDeadLineNumber((LineNumberNode)insn, index2, frames2) : frames2[index2] == null);
    }

    private final boolean isDeadLineNumber(LineNumberNode insn, int index2, Object[] frames2) {
        AbstractInsnNode abstractInsnNode;
        AbstractInsnNode finger = insn;
        int fingerIndex = index2;
        boolean hasDeadInsn = false;
        while ((abstractInsnNode = finger.getNext()) != null) {
            finger = abstractInsnNode;
            int n = fingerIndex;
            fingerIndex = n + 1;
            abstractInsnNode = finger;
            if (abstractInsnNode instanceof LabelNode) continue;
            if (abstractInsnNode instanceof LineNumberNode) {
                if (((LineNumberNode)finger).line == insn.line) continue;
                return hasDeadInsn;
            }
            if (frames2[fingerIndex] != null) {
                return false;
            }
            hasDeadInsn = true;
        }
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer$Result;", "", "removedNodes", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "(Ljava/util/Set;)V", "hasRemovedAnything", "", "isAlive", "node", "isRemoved", "backend"})
    public static final class Result {
        @NotNull
        private final Set<AbstractInsnNode> removedNodes;

        public Result(@NotNull Set<? extends AbstractInsnNode> removedNodes) {
            Intrinsics.checkNotNullParameter(removedNodes, (String)"removedNodes");
            this.removedNodes = removedNodes;
        }

        public final boolean hasRemovedAnything() {
            Collection collection = this.removedNodes;
            boolean bl = false;
            return !collection.isEmpty();
        }

        public final boolean isRemoved(@NotNull AbstractInsnNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.removedNodes.contains(node);
        }

        public final boolean isAlive(@NotNull AbstractInsnNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return !this.isRemoved(node);
        }
    }
}

