/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\t2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"generateDefaultInitializerForType", "", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "g", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getEffectiveValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isExported", "", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "backend.wasm"})
public final class DeclarationGeneratorKt {
    public static final void generateDefaultInitializerForType(@NotNull WasmType type2, @NotNull WasmExpressionBuilder g) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        WasmType wasmType = type2;
        if (Intrinsics.areEqual((Object)wasmType, (Object)WasmI32.INSTANCE)) {
            g.buildConstI32(0);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmI64.INSTANCE)) {
            g.buildConstI64(0L);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmF32.INSTANCE)) {
            g.buildConstF32(0.0f);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmF64.INSTANCE)) {
            g.buildConstF64(0.0);
        } else if (wasmType instanceof WasmRefNullType) {
            g.buildRefNull(((WasmRefNullType)type2).getHeapType());
        } else if (wasmType instanceof WasmExternRef) {
            g.buildRefNull(WasmHeapType.Simple.Extern.INSTANCE);
        } else {
            if (Intrinsics.areEqual((Object)wasmType, (Object)WasmUnreachableType.INSTANCE)) {
                String string2 = "Unreachable type can't be initialized";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String string3 = Intrinsics.stringPlus((String)"Unknown value type ", (Object)type2.getName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
    }

    @NotNull
    public static final List<IrValueParameter> getEffectiveValueParameters(@NotNull IrFunction $this$getEffectiveValueParameters) {
        Object[] objectArray;
        Object[] objectArray2;
        Intrinsics.checkNotNullParameter((Object)$this$getEffectiveValueParameters, (String)"<this>");
        if ($this$getEffectiveValueParameters instanceof IrConstructor) {
            objectArray2 = IrUtilsKt.getParentAsClass($this$getEffectiveValueParameters).getThisReceiver();
            Intrinsics.checkNotNull((Object)objectArray2);
            objectArray = objectArray2;
        } else {
            objectArray = null;
        }
        Object[] implicitThis = objectArray;
        objectArray2 = new IrValueParameter[]{implicitThis, $this$getEffectiveValueParameters.getDispatchReceiverParameter(), $this$getEffectiveValueParameters.getExtensionReceiverParameter()};
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray2), (Iterable)$this$getEffectiveValueParameters.getValueParameters());
    }

    public static final boolean isExported(@NotNull IrFunction $this$isExported, @NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isExported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return Intrinsics.areEqual((Object)$this$isExported.getVisibility(), (Object)DescriptorVisibilities.PUBLIC) && CollectionsKt.contains((Iterable)context2.getAdditionalExportedDeclarations(), (Object)IrUtilsKt.getFqNameWhenAvailable($this$isExported));
    }
}

