/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.gradle.plugins.upx;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.file.archive.compression.URIBuilder;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.gradle.plugins.PluginUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/gradle/plugins/upx/XZArchiver;", "Lorg/gradle/api/resources/ReadableResource;", "resource", "Lorg/gradle/api/resources/internal/ReadableResourceInternal;", "(Lorg/gradle/api/resources/internal/ReadableResourceInternal;)V", "uri", "Ljava/net/URI;", "getBaseName", "", "getDisplayName", "getURI", "read", "Ljava/io/InputStream;", "toString", "package-search-gradle-plugins"})
public final class XZArchiver
implements ReadableResource {
    private final URI uri;
    private final ReadableResourceInternal resource;

    @NotNull
    public String getDisplayName() {
        String string = this.resource.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resource.displayName");
        return string;
    }

    @NotNull
    public URI getURI() {
        return this.uri;
    }

    @NotNull
    public String getBaseName() {
        return this.getDisplayName();
    }

    @NotNull
    public InputStream read() {
        File file = this.resource.getBackingFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resource.backingFile");
        return (InputStream)PluginUtilsKt.lzma2(PluginUtilsKt.seekable(file));
    }

    @NotNull
    public String toString() {
        return this.getDisplayName();
    }

    public XZArchiver(@NotNull ReadableResourceInternal resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.resource = resource;
        URI uRI = new URIBuilder(this.resource.getURI()).schemePrefix("xz:").build();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"URIBuilder(resource.uri)\u2026hemePrefix(\"xz:\").build()");
        this.uri = uRI;
    }
}

