/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.gradle.plugins.docker;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.file.CopySourceSpec;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.TaskContainerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.gradle.plugins.PluginUtilsKt;
import org.jetbrains.gradle.plugins.docker.DockerImage;
import org.jetbrains.gradle.plugins.docker.JvmBaseImages;
import org.jetbrains.gradle.plugins.docker.tasks.DockerBuildSpec;
import org.jetbrains.gradle.plugins.docker.tasks.DockerPushSpec;
import org.jetbrains.gradle.plugins.docker.tasks.GenerateJvmAppDockerfile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u00018B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010#\u001a\u00020\u0003H\u00c2\u0003J\t\u0010$\u001a\u00020\u0005H\u00c2\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J1\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\u001f\u0010,\u001a\u00020\u00132\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014J\b\u0010.\u001a\u00020\u0003H\u0016J\t\u0010/\u001a\u000200H\u00d6\u0001J\u000e\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0003J\u0016\u00101\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003J\u0010\u00101\u001a\u00020\u00132\b\b\u0002\u00104\u001a\u000205J\u001f\u00106\u001a\u00020\u00132\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014J\t\u00107\u001a\u00020\u0003H\u00d6\u0001R(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR+\u0010\u000f\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u00140\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00069"}, d2={"Lorg/jetbrains/gradle/plugins/docker/DockerImage;", "Lorg/gradle/api/Named;", "name", "", "project", "Lorg/gradle/api/Project;", "imageName", "imageVersion", "(Ljava/lang/String;Lorg/gradle/api/Project;Ljava/lang/String;Ljava/lang/String;)V", "buildArgs", "", "getBuildArgs", "()Ljava/util/Map;", "setBuildArgs", "(Ljava/util/Map;)V", "copySpecActions", "", "Lkotlin/Function1;", "Lorg/gradle/api/file/CopySourceSpec;", "", "Lkotlin/ExtensionFunctionType;", "getCopySpecActions$package_search_gradle_plugins", "()Ljava/util/List;", "getImageName", "()Ljava/lang/String;", "setImageName", "(Ljava/lang/String;)V", "imageNameWithTag", "getImageNameWithTag", "getImageVersion", "setImageVersion", "tasksCustomizationContainer", "Lorg/jetbrains/gradle/plugins/docker/DockerImage$Tasks;", "getTasksCustomizationContainer$package_search_gradle_plugins", "()Lorg/jetbrains/gradle/plugins/docker/DockerImage$Tasks;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "files", "action", "getName", "hashCode", "", "setupJvmApp", "imageNameAndTag", "imageTag", "baseImage", "Lorg/jetbrains/gradle/plugins/docker/JvmBaseImages;", "taskProviders", "toString", "Tasks", "package-search-gradle-plugins"})
public final class DockerImage
implements Named {
    @NotNull
    private Map<String, String> buildArgs;
    @NotNull
    private final List<Function1<CopySourceSpec, Unit>> copySpecActions;
    @NotNull
    private final Tasks tasksCustomizationContainer;
    private final String name;
    private final Project project;
    @NotNull
    private String imageName;
    @NotNull
    private String imageVersion;

    @NotNull
    public final String getImageNameWithTag() {
        return this.imageName + ':' + this.imageVersion;
    }

    @NotNull
    public final Map<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    public final void setBuildArgs(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.buildArgs = map;
    }

    @NotNull
    public final List<Function1<CopySourceSpec, Unit>> getCopySpecActions$package_search_gradle_plugins() {
        return this.copySpecActions;
    }

    @NotNull
    public final Tasks getTasksCustomizationContainer$package_search_gradle_plugins() {
        return this.tasksCustomizationContainer;
    }

    public final void files(@NotNull Function1<? super CopySourceSpec, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.copySpecActions.add(action);
    }

    public final void taskProviders(@NotNull Function1<? super Tasks, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Tasks tasks = this.tasksCustomizationContainer;
        action.invoke((Object)tasks);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public final void setupJvmApp(@NotNull String imageNameAndTag) {
        Intrinsics.checkNotNullParameter((Object)imageNameAndTag, (String)"imageNameAndTag");
        this.setupJvmApp(StringsKt.substringBeforeLast$default((String)imageNameAndTag, (String)":", null, (int)2, null), StringsKt.substringAfterLast$default((String)imageNameAndTag, (String)":", null, (int)2, null));
    }

    public final void setupJvmApp(@NotNull String imageName, @NotNull String imageTag) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        Intrinsics.checkNotNullParameter((Object)imageTag, (String)"imageTag");
        this.setupJvmApp(new JvmBaseImages.Custom(imageName, imageTag));
    }

    /*
     * WARNING - void declaration
     */
    public final void setupJvmApp(@NotNull JvmBaseImages baseImage) {
        GenerateJvmAppDockerfile generateJvmAppDockerfile;
        Object object;
        Intrinsics.checkNotNullParameter((Object)baseImage, (String)"baseImage");
        PluginContainer pluginContainer = this.project.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.plugins");
        PluginContainer $this$has$iv = pluginContainer;
        boolean $i$f$has = false;
        if (!$this$has$iv.hasPlugin(ApplicationPlugin.class)) {
            this.project.getLogger().error("Application plugin not applied. Add 'id(\"application\")' in the 'plugins { }' block.");
            return;
        }
        Project $this$the$iv = this.project;
        boolean $i$f$the = false;
        boolean $i$f$typeOf = false;
        TypeOf type$iv = $i$f$typeOf = (TypeOf)new TypeOf<JavaApplication>(){};
        boolean bl = false;
        Object object2 = $this$the$iv.getConvention().findByType(type$iv);
        if (object2 == null) {
            object2 = object = $this$the$iv.getConvention().findPlugin(JavaApplication.class);
        }
        if (object2 == null) {
            object = $this$the$iv.getConvention().getByType(type$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeOf<T>().let { type -\u2026ion.getByType(type)\n    }");
        Property property = ((JavaApplication)object).getMainClass();
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.the<JavaApplication>().mainClass");
        if (!property.isPresent()) {
            this.project.getLogger().error("Application main class not set. Please set the \"application.mainClass\" property.");
            return;
        }
        String baseImageTaskNotation = StringsKt.capitalize((String)PluginUtilsKt.toCamelCase(baseImage.toString()));
        String generateDockerfileTaskName = "generate" + baseImageTaskNotation + "JvmAppDockerfile";
        Object object3 = this.project.getTasks().findByName(generateDockerfileTaskName);
        if (!(object3 instanceof GenerateJvmAppDockerfile)) {
            object3 = null;
        }
        if ((generateJvmAppDockerfile = (GenerateJvmAppDockerfile)((Object)object3)) == null) {
            void $this$register$iv;
            TaskContainer taskContainer = this.project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            type$iv = taskContainer;
            Function1 configuration$iv = (Function1)new Function1<GenerateJvmAppDockerfile, Unit>(baseImage){
                final /* synthetic */ JvmBaseImages $baseImage;

                public final void invoke(@NotNull GenerateJvmAppDockerfile $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                    $this$register.setBaseImage(this.$baseImage);
                    String baseFileName = StringsKt.replace$default((String)this.$baseImage.toString(), (String)":", (String)"-", (boolean)false, (int)4, null);
                    $this$register.setOutputDockerfile(new File($this$register.getOutputDockerfile().getParentFile(), baseFileName + "-app-dockerfile"));
                    Project project = $this$register.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    String string = project.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
                    $this$register.setAppName(string);
                }
                {
                    this.$baseImage = jvmBaseImages;
                    super(1);
                }
            };
            boolean $i$f$register = false;
            Function1 function1 = configuration$iv;
            TaskProvider taskProvider = $this$register$iv.register(generateDockerfileTaskName, GenerateJvmAppDockerfile.class, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void execute(Object p0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                }
            });
            generateJvmAppDockerfile = taskProvider;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        }
        GenerateJvmAppDockerfile extractImageTask2 = generateJvmAppDockerfile;
        this.files((Function1<? super CopySourceSpec, Unit>)((Function1)new Function1<CopySourceSpec, Unit>(this, (Object)extractImageTask2){
            final /* synthetic */ DockerImage this$0;
            final /* synthetic */ Object $extractImageTask;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CopySourceSpec $this$files) {
                void $this$named$iv;
                Intrinsics.checkNotNullParameter((Object)$this$files, (String)"$receiver");
                Object[] objectArray = new Object[1];
                TaskContainer taskContainer = DockerImage.access$getProject$p(this.this$0).getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                TaskCollection taskCollection = (TaskCollection)taskContainer;
                String name$iv = "installDist";
                boolean $i$f$named = false;
                objectArray[0] = TaskContainerExtensionsKt.named((TaskCollection)$this$named$iv, (String)name$iv, (KClass)Reflection.getOrCreateKotlinClass(Sync.class));
                $this$files.from(objectArray);
                $this$files.from(this.$extractImageTask, (Action)setupJvmApp.1.INSTANCE);
            }
            {
                this.this$0 = dockerImage;
                this.$extractImageTask = object;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void setupJvmApp$default(DockerImage dockerImage, JvmBaseImages jvmBaseImages, int n, Object object) {
        if ((n & 1) != 0) {
            jvmBaseImages = JvmBaseImages.OpenJRE8Slim.INSTANCE;
        }
        dockerImage.setupJvmApp(jvmBaseImages);
    }

    @NotNull
    public final String getImageName() {
        return this.imageName;
    }

    public final void setImageName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.imageName = string;
    }

    @NotNull
    public final String getImageVersion() {
        return this.imageVersion;
    }

    public final void setImageVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.imageVersion = string;
    }

    public DockerImage(@NotNull String name, @NotNull Project project, @NotNull String imageName, @NotNull String imageVersion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        Intrinsics.checkNotNullParameter((Object)imageVersion, (String)"imageVersion");
        this.name = name;
        this.project = project;
        this.imageName = imageName;
        this.imageVersion = imageVersion;
        this.buildArgs = new LinkedHashMap();
        this.copySpecActions = new ArrayList();
        this.tasksCustomizationContainer = new Tasks();
    }

    public /* synthetic */ DockerImage(String string, Project project, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = PluginUtilsKt.fromCamelCaseToKebabCase$default(string, false, 1, null);
        }
        if ((n & 8) != 0) {
            Object object = project.getVersion();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            string3 = (String)object;
        }
        this(string, project, string2, string3);
    }

    public static final /* synthetic */ Project access$getProject$p(DockerImage $this) {
        return $this.project;
    }

    private final String component1() {
        return this.name;
    }

    private final Project component2() {
        return this.project;
    }

    @NotNull
    public final String component3() {
        return this.imageName;
    }

    @NotNull
    public final String component4() {
        return this.imageVersion;
    }

    @NotNull
    public final DockerImage copy(@NotNull String name, @NotNull Project project, @NotNull String imageName, @NotNull String imageVersion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        Intrinsics.checkNotNullParameter((Object)imageVersion, (String)"imageVersion");
        return new DockerImage(name, project, imageName, imageVersion);
    }

    public static /* synthetic */ DockerImage copy$default(DockerImage dockerImage, String string, Project project, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = dockerImage.name;
        }
        if ((n & 2) != 0) {
            project = dockerImage.project;
        }
        if ((n & 4) != 0) {
            string2 = dockerImage.imageName;
        }
        if ((n & 8) != 0) {
            string3 = dockerImage.imageVersion;
        }
        return dockerImage.copy(string, project, string2, string3);
    }

    @NotNull
    public String toString() {
        return "DockerImage(name=" + this.name + ", project=" + this.project + ", imageName=" + this.imageName + ", imageVersion=" + this.imageVersion + ")";
    }

    public int hashCode() {
        String string = this.name;
        Project project = this.project;
        String string2 = this.imageName;
        String string3 = this.imageVersion;
        return (((string != null ? string.hashCode() : 0) * 31 + (project != null ? project.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DockerImage)) break block3;
                DockerImage dockerImage = (DockerImage)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)dockerImage.name) || !Intrinsics.areEqual((Object)this.project, (Object)dockerImage.project) || !Intrinsics.areEqual((Object)this.imageName, (Object)dockerImage.imageName) || !Intrinsics.areEqual((Object)this.imageVersion, (Object)dockerImage.imageVersion)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0011\u001a\u00020\u00072\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bJ\u001f\u0010\u0013\u001a\u00020\u00072\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bJ\u001f\u0010\u0014\u001a\u00020\u00072\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bR+\u0010\u0003\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR+\u0010\u000b\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR+\u0010\u000e\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/gradle/plugins/docker/DockerImage$Tasks;", "", "()V", "buildTaskActions", "", "Lkotlin/Function1;", "Lorg/jetbrains/gradle/plugins/docker/tasks/DockerBuildSpec;", "", "Lkotlin/ExtensionFunctionType;", "getBuildTaskActions$package_search_gradle_plugins", "()Ljava/util/List;", "prepareTaskActions", "Lorg/gradle/api/tasks/Sync;", "getPrepareTaskActions$package_search_gradle_plugins", "pushTaskActions", "Lorg/jetbrains/gradle/plugins/docker/tasks/DockerPushSpec;", "getPushTaskActions$package_search_gradle_plugins", "dockerBuildTaskProvider", "action", "dockerPrepareTaskProvider", "dockerPushTaskProvider", "package-search-gradle-plugins"})
    public static class Tasks {
        @NotNull
        private final List<Function1<Sync, Unit>> prepareTaskActions = new ArrayList();
        @NotNull
        private final List<Function1<DockerBuildSpec, Unit>> buildTaskActions = new ArrayList();
        @NotNull
        private final List<Function1<DockerPushSpec, Unit>> pushTaskActions = new ArrayList();

        @NotNull
        public final List<Function1<Sync, Unit>> getPrepareTaskActions$package_search_gradle_plugins() {
            return this.prepareTaskActions;
        }

        @NotNull
        public final List<Function1<DockerBuildSpec, Unit>> getBuildTaskActions$package_search_gradle_plugins() {
            return this.buildTaskActions;
        }

        @NotNull
        public final List<Function1<DockerPushSpec, Unit>> getPushTaskActions$package_search_gradle_plugins() {
            return this.pushTaskActions;
        }

        public final void dockerPrepareTaskProvider(@NotNull Function1<? super Sync, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.prepareTaskActions.add(action);
        }

        public final void dockerBuildTaskProvider(@NotNull Function1<? super DockerBuildSpec, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.buildTaskActions.add(action);
        }

        public final void dockerPushTaskProvider(@NotNull Function1<? super DockerPushSpec, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.pushTaskActions.add(action);
        }
    }
}

