/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks.actions;

import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;

public class ProcessGeneratedGraalResourceFilesAction
implements Action<Task> {
    private final Provider<Directory> inputDirectory;
    private final ListProperty<String> filterableEntries;

    public ProcessGeneratedGraalResourceFilesAction(Provider<Directory> inputDirectory, ListProperty<String> filterableEntries) {
        this.inputDirectory = inputDirectory;
        this.filterableEntries = filterableEntries;
    }

    public void execute(Task task) {
        try {
            for (File resourceFile : ((Directory)this.inputDirectory.get()).getAsFileTree()) {
                this.processFile(resourceFile);
            }
        }
        catch (IOException e) {
            throw new GradleException("An IO error occured when processing the agent generated files", (Throwable)e);
        }
    }

    protected void processFile(File file) throws IOException {
        if (file.getName().endsWith(".json")) {
            this.processJsonFile(file);
        }
    }

    protected void processJsonFile(File jsonFile) throws IOException {
        JsonSlurper json = new JsonSlurper();
        Object result = json.parse(jsonFile);
        Object filtered = this.filter(result);
        JsonGenerator generator = new JsonGenerator.Options().build();
        String processed = JsonOutput.prettyPrint((String)generator.toJson(filtered));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
            writer.write(processed);
        }
    }

    private Object filter(Object in) {
        Class<?> clazz = in.getClass();
        if (this.shouldFilterString(in)) {
            return null;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return this.filterList((List)in);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.filterMap((Map)in);
        }
        return in;
    }

    private Map<Object, Object> filterMap(Map<Object, Object> map) {
        if (this.shouldFilterString(map.get("name"))) {
            return null;
        }
        HashMap<Object, Object> out = new HashMap<Object, Object>(map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.shouldFilterString(value)) continue;
            out.put(key, this.filter(value));
        }
        return out;
    }

    private boolean shouldFilterString(Object value) {
        if (value instanceof CharSequence) {
            String string = value.toString();
            return ((List)this.filterableEntries.get()).stream().anyMatch(string::startsWith);
        }
        return false;
    }

    private List<Object> filterList(List<Object> in) {
        ArrayList<Object> out = new ArrayList<Object>(in.size());
        for (Object element : in) {
            Object filtered = this.filter(element);
            if (filtered == null || filtered instanceof Collection && ((Collection)filtered).isEmpty()) continue;
            out.add(filtered);
        }
        return out;
    }
}

