/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.buildtools.gradle.internal.GraalVMReachabilityMetadataService;
import org.graalvm.reachability.DirectoryConfiguration;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class CollectReachabilityMetadata
extends DefaultTask {
    private Configuration classpath;

    @Classpath
    @Optional
    public Configuration getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Configuration classpath) {
        this.classpath = classpath;
    }

    @Internal
    public abstract Property<GraalVMReachabilityMetadataService> getMetadataService();

    @Input
    @Optional
    public abstract Property<URI> getUri();

    @Input
    @Optional
    public abstract Property<String> getVersion();

    @Input
    @Optional
    public abstract SetProperty<String> getExcludedModules();

    @Input
    @Optional
    public abstract MapProperty<String, String> getModuleToConfigVersion();

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getInto();

    @TaskAction
    void copyReachabilityMetadata() throws IOException {
        GraalVMReachabilityMetadataService service = (GraalVMReachabilityMetadataService)this.getMetadataService().get();
        Configuration classpath = this.classpath != null ? this.classpath : this.getProject().getConfigurations().getByName("runtimeClasspath");
        Objects.requireNonNull(classpath);
        Set excludedModules = (Set)this.getExcludedModules().getOrElse(Collections.emptySet());
        Map forcedVersions = (Map)this.getModuleToConfigVersion().getOrElse(Collections.emptyMap());
        for (ResolvedComponentResult component : classpath.getIncoming().getResolutionResult().getAllComponents()) {
            ModuleVersionIdentifier moduleVersion = component.getModuleVersion();
            Set<DirectoryConfiguration> configurations = service.findConfigurationsFor(excludedModules, forcedVersions, moduleVersion);
            DirectoryConfiguration.copy(configurations, (Path)((Directory)this.getInto().get()).getAsFile().toPath());
        }
    }
}

