/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.gradle.internal.GraalVMReachabilityMetadataService;
import org.graalvm.buildtools.utils.DynamicAccessMetadataUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateDynamicAccessMetadata
extends DefaultTask {
    private static final String LIBRARY_AND_FRAMEWORK_LIST = "library-and-framework-list.json";

    public void setClasspath(Configuration classpath) {
        this.getRuntimeClasspathGraph().set(classpath.getIncoming().getResolutionResult().getRootComponent());
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        for (ResolvedArtifactResult artifact : (Set)classpath.getIncoming().getArtifacts().getResolvedArtifacts().get()) {
            ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
            if (!(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
            ModuleComponentIdentifier mci = (ModuleComponentIdentifier)componentIdentifier;
            String coordinates = mci.getGroup() + ":" + mci.getModule();
            map.put((CallSite)((Object)coordinates), artifact.getFile().getAbsolutePath());
        }
        this.getCoordinatesToPath().set(map);
    }

    @Input
    public abstract Property<ResolvedComponentResult> getRuntimeClasspathGraph();

    @Input
    public abstract MapProperty<String, String> getCoordinatesToPath();

    @Internal
    public abstract Property<GraalVMReachabilityMetadataService> getMetadataService();

    @OutputFile
    public abstract RegularFileProperty getOutputJson();

    @TaskAction
    public void generate() {
        Optional<Path> repositoryDirectory = ((GraalVMReachabilityMetadataService)this.getMetadataService().get()).getRepositoryDirectory();
        if (repositoryDirectory.isEmpty()) {
            GraalVMLogger.of(this.getLogger()).log("No reachability metadata repository is configured or available.");
            return;
        }
        File jsonFile = repositoryDirectory.get().resolve(LIBRARY_AND_FRAMEWORK_LIST).toFile();
        if (!jsonFile.exists()) {
            GraalVMLogger.of(this.getLogger()).log("{} is not packaged with the provided reachability metadata repository.", LIBRARY_AND_FRAMEWORK_LIST);
            return;
        }
        try {
            Set artifactsToInclude = DynamicAccessMetadataUtils.readArtifacts((File)jsonFile);
            ResolvedComponentResult root = (ResolvedComponentResult)this.getRuntimeClasspathGraph().get();
            Map<String, Set<String>> exportMap = this.buildExportMap(root, artifactsToInclude, (Map)this.getCoordinatesToPath().get());
            this.serializeExportMap((File)this.getOutputJson().getAsFile().get(), exportMap);
        }
        catch (IOException e) {
            GraalVMLogger.of(this.getLogger()).log("Failed to generate dynamic access metadata: {}", e);
        }
    }

    private Map<String, Set<String>> buildExportMap(ResolvedComponentResult root, Set<String> artifactsToInclude, Map<String, String> coordinatesToPath) {
        HashMap<String, Set<String>> exportMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> dependencyMap = new HashMap<String, Set<String>>();
        this.collectDependencies(root, dependencyMap, new LinkedHashSet<String>(), coordinatesToPath);
        for (Map.Entry entry : dependencyMap.entrySet()) {
            String absolutePath;
            String coordinates = (String)entry.getKey();
            if (!artifactsToInclude.contains(coordinates) || (absolutePath = coordinatesToPath.get(coordinates)) == null) continue;
            exportMap.put(absolutePath, (Set)entry.getValue());
        }
        return exportMap;
    }

    private void collectDependencies(ResolvedComponentResult node, Map<String, Set<String>> dependencyMap, Set<String> visited, Map<String, String> coordinatesToPath) {
        String coordinates = null;
        ComponentIdentifier componentIdentifier = node.getId();
        if (componentIdentifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier mci = (ModuleComponentIdentifier)componentIdentifier;
            coordinates = mci.getGroup() + ":" + mci.getModule();
        }
        if (coordinates != null && !visited.add(coordinates)) {
            return;
        }
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        for (DependencyResult dep : node.getDependencies()) {
            ResolvedDependencyResult resolved;
            ResolvedComponentResult target;
            ComponentIdentifier componentIdentifier2;
            if (!(dep instanceof ResolvedDependencyResult) || !((componentIdentifier2 = (target = (resolved = (ResolvedDependencyResult)dep).getSelected()).getId()) instanceof ModuleComponentIdentifier)) continue;
            ModuleComponentIdentifier targetMci = (ModuleComponentIdentifier)componentIdentifier2;
            String dependencyCoordinates = targetMci.getGroup() + ":" + targetMci.getModule();
            String dependencyPath = coordinatesToPath.get(dependencyCoordinates);
            if (dependencyPath != null) {
                dependencies.add(dependencyPath);
            }
            this.collectDependencies(target, dependencyMap, visited, coordinatesToPath);
            Set<String> transitiveDependencies = dependencyMap.get(dependencyCoordinates);
            if (transitiveDependencies == null) continue;
            dependencies.addAll(transitiveDependencies);
        }
        dependencyMap.put(coordinates, dependencies);
    }

    private void serializeExportMap(File outputFile, Map<String, Set<String>> exportMap) throws IOException {
        DynamicAccessMetadataUtils.serialize((File)outputFile, exportMap);
        GraalVMLogger.of(this.getLogger()).lifecycle("Dynamic Access Metadata written into " + String.valueOf(outputFile));
    }
}

