/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.buildtools.gradle.internal.ConfigurationCacheSupport;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public class NativeImageExecutableLocator {
    public static Provider<String> graalvmHomeProvider(ProviderFactory providers) {
        return NativeImageExecutableLocator.graalvmHomeProvider(providers, new Diagnostics());
    }

    public static Provider<String> graalvmHomeProvider(ProviderFactory providers, Diagnostics diagnostics) {
        return diagnostics.fromEnvVar("GRAALVM_HOME", providers).orElse(diagnostics.fromEnvVar("JAVA_HOME", providers));
    }

    public static File findNativeImageExecutable(Property<JavaLauncher> javaLauncher, Provider<Boolean> disableToolchainDetection, Provider<String> graalvmHomeProvider, ExecOperations execOperations, GraalVMLogger logger, Diagnostics diagnostics) {
        File graalVmHomeGuess;
        File guPath;
        File executablePath = null;
        boolean toolchainDetectionIsDisabled = Boolean.TRUE.equals(disableToolchainDetection.get());
        if ((toolchainDetectionIsDisabled || !javaLauncher.isPresent()) && graalvmHomeProvider.isPresent()) {
            diagnostics.disableToolchainDetection();
            String graalvmHome = (String)graalvmHomeProvider.get();
            executablePath = Paths.get(graalvmHome, new String[0]).resolve("bin/" + SharedConstants.NATIVE_IMAGE_EXE).toFile();
        }
        if (executablePath == null) {
            JavaInstallationMetadata metadata = ((JavaLauncher)javaLauncher.get()).getMetadata();
            diagnostics.withToolchain(metadata);
            executablePath = metadata.getInstallationPath().file("bin/" + SharedConstants.NATIVE_IMAGE_EXE).getAsFile();
        }
        if ((guPath = (graalVmHomeGuess = executablePath.getParentFile()).toPath().resolve(SharedConstants.GU_EXE).toFile()).exists() && !executablePath.exists()) {
            logger.log("Native Image executable wasn't found. We will now try to download it. ");
            ExecResult res = execOperations.exec(spec -> {
                spec.args(new Object[]{"install", "native-image"});
                spec.setExecutable((Object)Paths.get(graalVmHomeGuess.getAbsolutePath(), SharedConstants.GU_EXE));
            });
            if (res.getExitValue() != 0) {
                throw new GradleException("Native Image executable wasn't found, and '" + SharedConstants.GU_EXE + "' tool failed to install it.\nMake sure to declare the GRAALVM_HOME or JAVA_HOME environment variable or install GraalVM with native-image in a standard location recognized by Gradle Java toolchain support");
            }
            diagnostics.withGuInstall();
        }
        if (!executablePath.exists()) {
            throw new GradleException(String.valueOf(executablePath) + " wasn't found. This probably means that JDK isn't a GraalVM distribution.\nMake sure to declare the GRAALVM_HOME or JAVA_HOME environment variable or install GraalVM withnative-image in a standard location recognized by Gradle Java toolchain support");
        }
        diagnostics.withExecutablePath(executablePath);
        return executablePath;
    }

    public static final class Diagnostics {
        private boolean toolchainDetectionDisabled;
        private String envVar;
        private boolean guInstall;
        private File executablePath;
        private JavaInstallationMetadata toolchain;

        public Provider<String> fromEnvVar(String envVar, ProviderFactory factory) {
            return factory.environmentVariable(envVar).map(ConfigurationCacheSupport.serializableTransformerOf(value -> {
                this.envVar = envVar;
                return value;
            }));
        }

        public void withToolchain(JavaInstallationMetadata toolchain) {
            this.toolchain = toolchain;
            this.envVar = null;
        }

        public void disableToolchainDetection() {
            this.toolchainDetectionDisabled = true;
        }

        public void withGuInstall() {
            this.guInstall = true;
        }

        public void withExecutablePath(File path) {
            this.executablePath = path;
        }

        public List<String> getDiagnostics() {
            ArrayList<Object> diags = new ArrayList<Object>();
            diags.add("GraalVM Toolchain detection is " + (this.toolchainDetectionDisabled ? "disabled" : "enabled"));
            if (this.envVar != null) {
                diags.add("GraalVM location read from environment variable: " + this.envVar);
            }
            if (this.guInstall) {
                diags.add("Native Image executable was installed using 'gu' tool");
            }
            if (this.toolchain != null) {
                diags.add("GraalVM uses toolchain detection. Selected:");
                diags.add("   - language version: " + String.valueOf(this.toolchain.getLanguageVersion()));
                diags.add("   - vendor: " + this.toolchain.getVendor());
                diags.add("   - runtime version: " + this.toolchain.getJavaRuntimeVersion());
            }
            if (this.executablePath != null) {
                try {
                    diags.add("Native Image executable path: " + this.executablePath.getCanonicalPath());
                }
                catch (IOException e) {
                    diags.add("Native Image executable path: " + this.executablePath.getAbsolutePath());
                }
            }
            return Collections.unmodifiableList(diags);
        }
    }
}

