/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.tasks.CreateLayerOptions;
import org.graalvm.buildtools.gradle.tasks.LayerOptions;
import org.graalvm.buildtools.gradle.tasks.UseLayerOptions;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.process.CommandLineArgumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeImageCommandLineProvider
implements CommandLineArgumentProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeImageCommandLineProvider.class);
    private static final Transformer<Boolean, Boolean> NEGATE = b -> b == false;
    private final Provider<NativeImageOptions> options;
    private final Provider<String> executableName;
    private final Provider<String> workingDirectory;
    private final Provider<String> outputDirectory;
    private final Provider<RegularFile> classpathJar;
    private final Provider<Boolean> useArgFile;
    private final Provider<Integer> majorJDKVersion;
    private final Provider<Boolean> useColors;

    public NativeImageCommandLineProvider(Provider<NativeImageOptions> options, Provider<String> executableName, Provider<String> workingDirectory, Provider<String> outputDirectory, Provider<RegularFile> classpathJar, Provider<Boolean> useArgFile, Provider<Integer> majorJDKVersion, Provider<Boolean> useColors) {
        this.options = options;
        this.executableName = executableName;
        this.workingDirectory = workingDirectory;
        this.outputDirectory = outputDirectory;
        this.classpathJar = classpathJar;
        this.useArgFile = useArgFile;
        this.majorJDKVersion = majorJDKVersion;
        this.useColors = useColors;
    }

    @Nested
    public Provider<NativeImageOptions> getOptions() {
        return this.options;
    }

    @Input
    public Provider<String> getExecutableName() {
        return this.executableName;
    }

    @Input
    public Provider<String> getOutputDirectory() {
        return this.outputDirectory;
    }

    @InputFile
    public Provider<RegularFile> getClasspathJar() {
        return this.classpathJar;
    }

    public List<String> asArguments() {
        ArrayList<String> actualCliArgs;
        NativeImageOptions options = (NativeImageOptions)this.getOptions().get();
        ArrayList<String> cliArgs = new ArrayList<String>(20);
        boolean hasLayers = !options.getLayers().isEmpty();
        String layerCreateName = null;
        ConfigurableFileCollection jarsClasspath = null;
        if (hasLayers) {
            LOGGER.warn("Experimental support for layered images enabled. DSL may change at any time.");
            cliArgs.add("-H:+UnlockExperimentalVMOptions");
            DomainObjectSet layers = options.getLayers();
            StringBuilder arg = new StringBuilder();
            for (LayerOptions layer : layers) {
                if (arg.length() > 0) {
                    arg.append(" ");
                }
                if (layer instanceof CreateLayerOptions) {
                    boolean hasJars;
                    CreateLayerOptions create = (CreateLayerOptions)layer;
                    layerCreateName = (String)layer.getLayerName().get();
                    arg.append("-H:LayerCreate=");
                    arg.append(layerCreateName).append(".nil");
                    List modules = (List)create.getModules().get();
                    jarsClasspath = create.getJars();
                    boolean hasModules = !modules.isEmpty();
                    boolean hasPackage = create.getPackages().isPresent() && !((List)create.getPackages().get()).isEmpty();
                    boolean bl = hasJars = !jarsClasspath.getFiles().isEmpty();
                    if (!hasModules && !hasPackage && !hasJars) continue;
                    List packages = (List)create.getPackages().get();
                    arg.append(",");
                    if (hasModules) {
                        arg.append(modules.stream().map(m -> "module=" + m).collect(Collectors.joining(",")));
                    }
                    if (hasPackage) {
                        if (hasModules) {
                            arg.append(",");
                        }
                        arg.append(packages.stream().map(p -> "package=" + p).collect(Collectors.joining(",")));
                    }
                    if (!hasJars) continue;
                    if (hasModules || hasPackage) {
                        arg.append(",");
                    }
                    arg.append(jarsClasspath.getFiles().stream().map(p -> "path=" + String.valueOf(p)).collect(Collectors.joining(",")));
                    continue;
                }
                UseLayerOptions layerUse = (UseLayerOptions)layer;
                arg.append("-H:LayerUse=");
                arg.append(((File)layerUse.getLayerFile().getAsFile().get()).getAbsolutePath());
            }
            cliArgs.add(arg.toString());
        }
        cliArgs.addAll((Collection)options.getExcludeConfigArgs().get());
        String classpathString = this.buildClasspathString(options).trim();
        if (!classpathString.isEmpty()) {
            cliArgs.add("-cp");
            cliArgs.add(classpathString);
        } else if (jarsClasspath != null && !jarsClasspath.isEmpty()) {
            cliArgs.add("-cp");
            cliArgs.add(jarsClasspath.getAsPath());
        }
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getDebug(), "-g");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getFallback().map(NEGATE), "--no-fallback");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getVerbose(), "--verbose");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getSharedLibrary(), "--shared");
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getQuickBuild(), "-Ob");
        if (((Boolean)this.useColors.get()).booleanValue()) {
            NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getRichOutput(), (Integer)this.majorJDKVersion.getOrElse((Object)-1) >= 21 ? "--color" : "-H:+BuildOutputColorful");
        }
        NativeImageCommandLineProvider.appendBooleanOption(cliArgs, (Provider<Boolean>)options.getPgoInstrument(), "--pgo-instrument");
        Object targetOutputPath = (String)this.getExecutableName().get();
        if (layerCreateName != null) {
            targetOutputPath = layerCreateName;
        }
        if (this.getOutputDirectory().isPresent()) {
            targetOutputPath = (String)this.getOutputDirectory().get() + File.separator + (String)targetOutputPath;
        }
        cliArgs.add("-o");
        cliArgs.add((String)targetOutputPath);
        ((Map)options.getSystemProperties().get()).forEach((n, v) -> {
            if (v != null) {
                cliArgs.add("-D" + n + "=\"" + String.valueOf(v) + "\"");
            }
        });
        ((List)options.getJvmArgs().get()).forEach(jvmArg -> cliArgs.add("-J" + jvmArg));
        String configFiles = ((Set)options.getConfigurationFileDirectories().getElements().get()).stream().map(FileSystemLocation::getAsFile).map(File::getAbsolutePath).collect(Collectors.joining(","));
        if (!configFiles.isEmpty()) {
            cliArgs.add("-H:ConfigurationFileDirectories=" + configFiles);
        }
        if (Boolean.FALSE.equals(options.getPgoInstrument().get()) && options.getPgoProfilesDirectory().isPresent()) {
            FileTree files = ((Directory)options.getPgoProfilesDirectory().get()).getAsFileTree();
            Set profiles = files.filter(f -> f.getName().endsWith(".iprof")).getFiles();
            for (File profile : profiles) {
                cliArgs.add("--pgo=" + String.valueOf(profile));
            }
        }
        cliArgs.addAll((Collection)options.getBuildArgs().get());
        if (((Boolean)this.useArgFile.getOrElse((Object)true)).booleanValue()) {
            Path argFileDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            actualCliArgs = new ArrayList(NativeImageUtils.convertToArgsFile(cliArgs, (Path)argFileDir, (Path)Paths.get((String)this.workingDirectory.get(), new String[0])));
        } else {
            actualCliArgs = cliArgs;
        }
        if (options.getMainClass().isPresent()) {
            actualCliArgs.add((String)options.getMainClass().get());
        }
        return Collections.unmodifiableList(actualCliArgs);
    }

    protected String buildClasspathString(NativeImageOptions options) {
        String classpathString = this.classpathJar.isPresent() ? ((RegularFile)this.classpathJar.get()).getAsFile().getAbsolutePath() : options.getClasspath().getAsPath();
        return classpathString;
    }

    private static void appendBooleanOption(List<String> cliArgs, Provider<Boolean> provider, String whenTrue) {
        if (((Boolean)provider.get()).booleanValue()) {
            cliArgs.add(whenTrue);
        }
    }
}

