/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;

public abstract class NativeRunTask
extends DefaultTask {
    public static final String TASK_NAME = "nativeRun";

    @InputFile
    public abstract RegularFileProperty getImage();

    @Input
    public abstract ListProperty<String> getRuntimeArgs();

    @Input
    @Optional
    public abstract MapProperty<String, String> getEnvironment();

    @Input
    public abstract ListProperty<String> getInternalRuntimeArgs();

    @Inject
    protected abstract ExecOperations getExecOperations();

    public NativeRunTask() {
        this.setDescription("Runs this project as a native-image application");
        this.setGroup("application");
    }

    @TaskAction
    public void exec() {
        this.getExecOperations().exec(spec -> {
            spec.setExecutable(((RegularFile)this.getImage().get()).getAsFile().getAbsolutePath());
            ArrayList allRuntimeArgs = new ArrayList((Collection)this.getInternalRuntimeArgs().get());
            allRuntimeArgs.addAll((Collection)this.getRuntimeArgs().get());
            spec.args(allRuntimeArgs);
            if (this.getEnvironment().isPresent()) {
                Map env = (Map)this.getEnvironment().get();
                for (Map.Entry entry : env.entrySet()) {
                    spec.environment((String)entry.getKey(), entry.getValue());
                }
            }
        });
    }
}

