/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.dsl.NativeResourcesOptions;
import org.graalvm.buildtools.gradle.dsl.agent.DeprecatedAgentOptions;
import org.graalvm.buildtools.gradle.internal.GraalVMLogger;
import org.graalvm.buildtools.utils.SharedConstants;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public abstract class BaseNativeImageOptions
implements NativeImageOptions {
    private static final GraalVMLogger LOGGER = GraalVMLogger.of(Logging.getLogger(BaseNativeImageOptions.class));
    private final String name;

    @Override
    @Internal
    public String getName() {
        return this.name;
    }

    @Override
    @Input
    public abstract Property<String> getImageName();

    @Override
    @Input
    @Optional
    public abstract Property<String> getMainClass();

    @Override
    @Input
    public abstract ListProperty<String> getBuildArgs();

    @Override
    @Input
    public abstract MapProperty<String, Object> getSystemProperties();

    @Override
    public abstract MapProperty<String, Object> getEnvironmentVariables();

    @Override
    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Override
    @Input
    public abstract ListProperty<String> getJvmArgs();

    @Override
    @Input
    public abstract ListProperty<String> getRuntimeArgs();

    @Override
    @Input
    public abstract Property<Boolean> getDebug();

    @Override
    @Input
    public abstract Property<Boolean> getFallback();

    @Override
    @Input
    public abstract Property<Boolean> getVerbose();

    @Override
    @Input
    public abstract Property<Boolean> getSharedLibrary();

    @Override
    @Input
    public abstract Property<Boolean> getQuickBuild();

    @Override
    @Input
    public abstract Property<Boolean> getRichOutput();

    @Override
    @Nested
    @Optional
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Override
    @InputFiles
    public abstract ConfigurableFileCollection getConfigurationFileDirectories();

    @Override
    @Input
    public abstract MapProperty<Object, List<String>> getExcludeConfig();

    @Override
    @Nested
    public abstract NativeResourcesOptions getResources();

    @Override
    public void resources(Action<? super NativeResourcesOptions> spec) {
        spec.execute((Object)this.getResources());
    }

    @Inject
    public BaseNativeImageOptions(String name, ProjectLayout layout, ObjectFactory objectFactory, ProviderFactory providers, JavaToolchainService toolchains, TaskContainer tasks, String defaultImageName) {
        this.name = name;
        this.getDebug().convention((Object)false);
        this.getFallback().convention((Object)false);
        this.getVerbose().convention((Object)false);
        this.getQuickBuild().convention(providers.environmentVariable("GRAALVM_QUICK_BUILD").map(env -> {
            LOGGER.logOnce("Quick build environment variable is set.");
            if (env.isEmpty()) {
                return true;
            }
            return Boolean.parseBoolean(env);
        }).orElse((Object)false));
        this.getRichOutput().convention((Object)(!SharedConstants.IS_CI && !SharedConstants.IS_WINDOWS && !SharedConstants.IS_DUMB_TERM && !SharedConstants.NO_COLOR ? 1 : 0));
        this.getSharedLibrary().convention((Object)false);
        this.getImageName().convention((Object)defaultImageName);
        this.getUseFatJar().convention((Object)false);
        this.getPgoInstrument().convention((Object)false);
        DirectoryProperty pgoProfileDir = objectFactory.directoryProperty();
        pgoProfileDir.convention(layout.getProjectDirectory().dir("src/pgo-profiles/" + name));
        this.getPgoProfilesDirectory().convention(pgoProfileDir.map(d -> d.getAsFile().exists() ? d : null));
    }

    private static Provider<Boolean> property(ProviderFactory providers, String name) {
        return providers.gradleProperty(name).map(Boolean::valueOf).orElse((Object)false);
    }

    @Override
    public BaseNativeImageOptions buildArgs(Object ... buildArgs) {
        this.getBuildArgs().addAll((Iterable)Arrays.stream(buildArgs).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions buildArgs(Iterable<?> buildArgs) {
        this.getBuildArgs().addAll((Iterable)StreamSupport.stream(buildArgs.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions systemProperties(Map<String, ?> properties) {
        MapProperty<String, Object> map = this.getSystemProperties();
        properties.forEach((key, value) -> map.put(key, (Object)(value == null ? null : String.valueOf(value))));
        return this;
    }

    @Override
    public BaseNativeImageOptions systemProperty(String name, Object value) {
        this.getSystemProperties().put((Object)name, (Object)(value == null ? null : String.valueOf(value)));
        return this;
    }

    @Override
    public BaseNativeImageOptions classpath(Object ... paths) {
        this.getClasspath().from(paths);
        return this;
    }

    @Override
    public BaseNativeImageOptions jvmArgs(Object ... arguments) {
        this.getJvmArgs().addAll((Iterable)Arrays.stream(arguments).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions jvmArgs(Iterable<?> arguments) {
        this.getJvmArgs().addAll((Iterable)StreamSupport.stream(arguments.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions runtimeArgs(Object ... arguments) {
        this.getRuntimeArgs().addAll((Iterable)Arrays.stream(arguments).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    public BaseNativeImageOptions runtimeArgs(Iterable<?> arguments) {
        this.getRuntimeArgs().addAll((Iterable)StreamSupport.stream(arguments.spliterator(), false).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    @Override
    @Nested
    public abstract DeprecatedAgentOptions getAgent();

    @Override
    public void agent(Action<? super DeprecatedAgentOptions> spec) {
        spec.execute((Object)this.getAgent());
    }
}

