/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal.index.modules;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.graalvm.reachability.internal.index.modules.ModuleToConfigDirectoryIndex;

public class StandardLocationModuleToConfigDirectoryIndex
implements ModuleToConfigDirectoryIndex {
    private final Path rootPath;

    public StandardLocationModuleToConfigDirectoryIndex(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public Set<Path> findConfigurationDirectories(String groupId, String artifactId) {
        Path candidate = this.rootPath.resolve(groupId.replace('.', '/') + "/" + artifactId);
        if (Files.isDirectory(candidate, new LinkOption[0])) {
            return Collections.singleton(candidate);
        }
        return Collections.emptySet();
    }
}

