/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.graalvm.reachability.JvmReachabilityMetadataRepository;
import org.graalvm.reachability.Query;
import org.graalvm.reachability.internal.DefaultQuery;
import org.graalvm.reachability.internal.index.artifacts.SingleModuleJsonVersionToConfigDirectoryIndex;
import org.graalvm.reachability.internal.index.artifacts.VersionToConfigDirectoryIndex;
import org.graalvm.reachability.internal.index.modules.FileSystemModuleToConfigDirectoryIndex;

public class FileSystemRepository
implements JvmReachabilityMetadataRepository {
    private final FileSystemModuleToConfigDirectoryIndex moduleIndex;
    private final Logger logger;
    private final Map<Path, VersionToConfigDirectoryIndex> artifactIndexes;
    private final Path rootDirectory;

    public FileSystemRepository(Path rootDirectory) {
        this(rootDirectory, new Logger(){});
    }

    public FileSystemRepository(Path rootDirectory, Logger logger) {
        this.moduleIndex = new FileSystemModuleToConfigDirectoryIndex(rootDirectory);
        this.logger = logger;
        this.artifactIndexes = new ConcurrentHashMap<Path, VersionToConfigDirectoryIndex>();
        this.rootDirectory = rootDirectory;
    }

    @Override
    public Set<Path> findConfigurationDirectoriesFor(Consumer<? super Query> queryBuilder) {
        DefaultQuery query = new DefaultQuery();
        queryBuilder.accept(query);
        return query.getArtifacts().stream().flatMap(artifactQuery -> {
            String groupId = artifactQuery.getGroupId();
            String artifactId = artifactQuery.getArtifactId();
            String version = artifactQuery.getVersion();
            return this.moduleIndex.findConfigurationDirectories(groupId, artifactId).stream().map(dir -> {
                VersionToConfigDirectoryIndex index = this.artifactIndexes.computeIfAbsent((Path)dir, SingleModuleJsonVersionToConfigDirectoryIndex::new);
                if (artifactQuery.getForcedConfig().isPresent()) {
                    String configVersion = artifactQuery.getForcedConfig().get();
                    this.logger.log(groupId, artifactId, version, "Configuration is forced to version " + configVersion);
                    return index.findForcedConfiguration(configVersion);
                }
                Optional<Path> configurationDirectory = index.findConfigurationDirectory(groupId, artifactId, version);
                if (!configurationDirectory.isPresent() && artifactQuery.isUseLatestVersion()) {
                    this.logger.log(groupId, artifactId, version, "Configuration directory not found. Trying latest version.");
                    configurationDirectory = index.findLatestConfigurationFor(groupId, artifactId);
                    if (!configurationDirectory.isPresent()) {
                        this.logger.log(groupId, artifactId, version, "Latest version not found!");
                    }
                }
                Optional<Path> finalConfigurationDirectory = configurationDirectory;
                this.logger.log(groupId, artifactId, version, () -> {
                    if (finalConfigurationDirectory.isPresent()) {
                        Path path = (Path)finalConfigurationDirectory.get();
                        return "Configuration directory is " + this.rootDirectory.relativize(path);
                    }
                    return "missing.";
                });
                return configurationDirectory;
            }).filter(Optional::isPresent).map(Optional::get);
        }).collect(Collectors.toSet());
    }

    public static interface Logger {
        default public void log(String groupId, String artifactId, String version, String message) {
            this.log(groupId, artifactId, version, () -> message);
        }

        default public void log(String groupId, String artifactId, String version, Supplier<String> message) {
        }
    }
}

