/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.reckon.gradle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

@UntrackedTask(because="Git tracks the state")
public abstract class ReckonCreateTagTask
extends DefaultTask {
    @TaskAction
    public void create() {
        if (!this.getTagName().isPresent()) {
            this.setDidWork(false);
            return;
        }
        this.tag(null, null, true);
    }

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Internal
    public abstract DirectoryProperty getRepoDirectory();

    @Input
    @Optional
    public abstract Property<String> getTagName();

    @Input
    public abstract Property<String> getTagMessage();

    private void tag(String userEmail, String userName, boolean allowRetry) {
        ByteArrayInputStream input = new ByteArrayInputStream(((String)this.getTagMessage().get()).getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add("git");
        if (userEmail != null && userName != null) {
            cmd.add("-c");
            cmd.add("user.email=" + userEmail);
            cmd.add("-c");
            cmd.add("user.name=" + userName);
        }
        cmd.add("tag");
        cmd.add("--annotate");
        cmd.add("--file");
        cmd.add("-");
        cmd.add((String)this.getTagName().get());
        ExecResult result = this.getExecOperations().exec(spec -> {
            spec.setWorkingDir((Object)this.getRepoDirectory());
            spec.setCommandLine((List)cmd);
            spec.setStandardInput((InputStream)input);
            spec.setStandardOutput((OutputStream)output);
            spec.setErrorOutput((OutputStream)error);
            spec.setIgnoreExitValue(true);
        });
        if (result.getExitValue() != 0) {
            String errorStr = error.toString(StandardCharsets.UTF_8);
            if (errorStr.contains(String.format("fatal: tag '%s' already exists", this.getTagName().get()))) {
                this.setDidWork(false);
            } else if (allowRetry && errorStr.contains("Committer identity unknown")) {
                String email = this.getRecentUserEmail();
                String name = this.getRecentUserName();
                System.err.printf("Tagging as recent committer %s <%s>, as this machine has no git identity set.%n", name, email);
                this.tag(email, name, false);
            } else {
                System.err.println(errorStr);
                result.assertNormalExitValue();
            }
        }
    }

    private String getRecentUserEmail() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.getExecOperations().exec(spec -> {
            spec.setWorkingDir((Object)this.getRepoDirectory());
            spec.setCommandLine(new Object[]{"git", "log", "-n", "1", "--pretty=format:%ae"});
            spec.setStandardOutput((OutputStream)output);
        });
        return output.toString();
    }

    private String getRecentUserName() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.getExecOperations().exec(spec -> {
            spec.setWorkingDir((Object)this.getRepoDirectory());
            spec.setCommandLine(new Object[]{"git", "log", "-n", "1", "--pretty=format:%an"});
            spec.setStandardOutput((OutputStream)output);
        });
        return output.toString();
    }
}

