/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.functions;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.api.AdapterContextAware;
import io.sundr.adapter.api.TypeLookup;
import io.sundr.model.ClassRef;
import io.sundr.model.Nameable;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.repo.DefinitionRepository;
import java.util.Optional;
import java.util.function.Function;

public class GetDefinition
implements Function<ClassRef, TypeDef> {
    public static GetDefinition FUNCTION = new GetDefinition();

    public static TypeDef of(ClassRef classRef) {
        return FUNCTION.apply(classRef);
    }

    public static TypeDef of(String fqcn) {
        return FUNCTION.apply(ClassRef.forName((String)fqcn));
    }

    @Override
    public TypeDef apply(ClassRef t) {
        String fullyQualifiedName = t.getFullyQualifiedName();
        return Optional.ofNullable(DefinitionRepository.getRepository().getDefinition(fullyQualifiedName)).orElseGet(() -> TypeLookup.lookup((String)fullyQualifiedName, (AdapterContextAware)AdapterContext.getContext()).orElseGet(() -> {
            String packageName = Nameable.getPackageName((String)fullyQualifiedName);
            String className = Nameable.getClassName((String)fullyQualifiedName);
            String outerTypeName = Nameable.getOuterTypeName((String)fullyQualifiedName);
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withName(className)).withPackageName(packageName)).withOuterTypeName(outerTypeName)).build();
        }));
    }
}

