/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject;

import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.MildConcurrentKeys;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.MildConcurrentValues;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.MildElements;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.MildKeys;
import io.spring.gradle.dependencymanagement.org.eclipse.sisu.inject.MildValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Weak {
    private Weak() {
    }

    public static <T> Collection<T> elements() {
        return Weak.elements(10);
    }

    public static <T> Collection<T> elements(int capacity) {
        return new MildElements(new ArrayList(capacity), false);
    }

    public static <K, V> Map<K, V> keys() {
        return Weak.keys(16);
    }

    public static <K, V> Map<K, V> keys(int capacity) {
        return new MildKeys(new HashMap(capacity), false);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentKeys() {
        return Weak.concurrentKeys(16, 4);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentKeys(int capacity, int concurrency) {
        return new MildConcurrentKeys(new ConcurrentHashMap(capacity, 0.75f, concurrency), false);
    }

    public static <K, V> Map<K, V> values() {
        return Weak.values(16);
    }

    public static <K, V> Map<K, V> values(int capacity) {
        return new MildValues(new HashMap(capacity), false);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentValues() {
        return Weak.concurrentValues(16, 4);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentValues(int capacity, int concurrency) {
        return new MildConcurrentValues(new ConcurrentHashMap(capacity, 0.75f, concurrency), false);
    }
}

