/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.dsl;

import groovy.lang.Closure;
import io.spring.gradle.dependencymanagement.dsl.DependencyHandler;
import io.spring.gradle.dependencymanagement.dsl.DependencySetHandler;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardDependencyHandler;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;

final class StandardDependencySetHandler
implements DependencySetHandler {
    private final String group;
    private final String version;
    private final DependencyManagementContainer dependencyManagementContainer;
    private final Configuration configuration;

    StandardDependencySetHandler(String group, String version, DependencyManagementContainer dependencyManagementContainer, Configuration configuration) {
        this.group = group;
        this.version = version;
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.configuration = configuration;
    }

    @Override
    public void entry(String name) {
        this.entry(name, (Action<DependencyHandler>)((Action)null));
    }

    @Override
    public void entry(String name, Closure<?> closure) {
        this.entry(name, (Action<DependencyHandler>)((Action)dependencyHandler -> {
            if (closure != null) {
                closure.setDelegate(dependencyHandler);
                closure.call();
            }
        }));
    }

    @Override
    public void entry(String name, Action<DependencyHandler> action) {
        StandardDependencyHandler dependencyHandler = new StandardDependencyHandler();
        if (action != null) {
            action.execute((Object)dependencyHandler);
        }
        this.dependencyManagementContainer.addManagedVersion(this.configuration, this.group, name, this.version, dependencyHandler.getExclusions());
    }
}

