/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.apache.maven.model.profile.activation;

import io.spring.gradle.dependencymanagement.org.apache.maven.model.Activation;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.ActivationProperty;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Profile;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblem;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblemCollector;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.profile.ProfileActivationContext;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.profile.activation.ProfileActivator;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.component.annotations.Component;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.util.StringUtils;

@Component(role=ProfileActivator.class, hint="property")
public class PropertyProfileActivator
implements ProfileActivator {
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        ActivationProperty property;
        boolean active = false;
        Activation activation = profile.getActivation();
        if (activation != null && (property = activation.getProperty()) != null) {
            String propValue;
            String name = property.getName();
            boolean reverseName = false;
            if (name != null && name.startsWith("!")) {
                reverseName = true;
                name = name.substring(1);
            }
            if (name == null || name.length() <= 0) {
                problems.add(ModelProblem.Severity.ERROR, "The property name is required to activate the profile " + profile.getId(), property.getLocation(""), null);
                return false;
            }
            String sysValue = context.getUserProperties().get(name);
            if (sysValue == null) {
                sysValue = context.getSystemProperties().get(name);
            }
            if (StringUtils.isNotEmpty(propValue = property.getValue())) {
                boolean reverseValue = false;
                if (propValue.startsWith("!")) {
                    reverseValue = true;
                    propValue = propValue.substring(1);
                }
                boolean result = propValue.equals(sysValue);
                active = reverseValue ? !result : result;
            } else {
                boolean result = StringUtils.isNotEmpty(sysValue);
                active = reverseName ? !result : result;
            }
        }
        return active;
    }
}

