/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingRequest;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblemCollector;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.validation.DefaultModelValidator;
import org.gradle.api.Action;

class RelaxedModelValidator
extends DefaultModelValidator {
    RelaxedModelValidator() {
    }

    @Override
    public void validateRawModel(Model model, final ModelBuildingRequest request, final ModelProblemCollector problems) {
        this.withNoDistributionManagementStatus(model, new Action<Model>(){

            public void execute(Model modifiedModel) {
                RelaxedModelValidator.super.validateRawModel(modifiedModel, request, problems);
            }
        });
    }

    @Override
    public void validateEffectiveModel(Model model, final ModelBuildingRequest request, final ModelProblemCollector problems) {
        this.withNoDistributionManagementStatus(model, new Action<Model>(){

            public void execute(Model modifiedModel) {
                RelaxedModelValidator.super.validateEffectiveModel(modifiedModel, request, problems);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withNoDistributionManagementStatus(Model model, Action<Model> action) {
        if (model.getDistributionManagement() != null) {
            String distributionManagementStatus = model.getDistributionManagement().getStatus();
            model.getDistributionManagement().setStatus(null);
            try {
                action.execute((Object)model);
            }
            finally {
                model.getDistributionManagement().setStatus(distributionManagementStatus);
            }
        } else {
            action.execute((Object)model);
        }
    }
}

