/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import org.gradle.api.Action;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlatformCategoryAttributeConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(PlatformCategoryAttributeConfigurer.class);

    PlatformCategoryAttributeConfigurer() {
    }

    void configureCategoryAttribute(Dependency dependency) {
        if (!(dependency instanceof ModuleDependency) || !this.isGradle5()) {
            return;
        }
        try {
            ((ModuleDependency)dependency).attributes((Action)new Action<AttributeContainer>(){

                public void execute(AttributeContainer container) {
                    Attribute attribute = Attribute.of((String)"org.gradle.category", String.class);
                    container.attribute(attribute, (Object)"platform");
                }
            });
        }
        catch (Throwable ex) {
            logger.debug("Failed to configure platform attribute", ex);
        }
    }

    private boolean isGradle5() {
        GradleVersion current = GradleVersion.current().getBaseVersion();
        return current.compareTo(GradleVersion.version((String)"5.0")) >= 0 && current.compareTo(GradleVersion.version((String)"6.0")) < 0;
    }
}

