/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import java.lang.reflect.Method;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlatformCategoryAttributeConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(PlatformCategoryAttributeConfigurer.class);

    PlatformCategoryAttributeConfigurer() {
    }

    void configureCategoryAttribute(Dependency dependency) {
        if (!(dependency instanceof ModuleDependency) || !this.isGradle5()) {
            return;
        }
        try {
            Method attributes = dependency.getClass().getMethod("attributes", Action.class);
            attributes.invoke((Object)dependency, new Action<Object>(){

                public void execute(Object container) {
                    try {
                        Class<?> attributeClass = Class.forName("org.gradle.api.attributes.Attribute");
                        Object attribute = attributeClass.getMethod("of", String.class, Class.class).invoke(null, "org.gradle.category", String.class);
                        Class.forName("org.gradle.api.attributes.AttributeContainer").getMethod("attribute", attributeClass, Object.class).invoke(container, attribute, "platform");
                    }
                    catch (Throwable ex) {
                        logger.debug("Failed to configure platform attribute", ex);
                    }
                }
            });
        }
        catch (Throwable ex) {
            logger.debug("Failed to configure platform attribute", ex);
        }
    }

    private boolean isGradle5() {
        return GradleVersion.current().getNextMajor().getVersion().startsWith("6.");
    }
}

