/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementSettings;
import io.spring.gradle.dependencymanagement.internal.ExclusionConfiguringAction;
import io.spring.gradle.dependencymanagement.internal.ExclusionResolver;
import io.spring.gradle.dependencymanagement.internal.VersionConfiguringAction;
import io.spring.gradle.dependencymanagement.internal.pom.PomResolver;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyManagementApplier
implements Action<Configuration> {
    private static final Logger logger = LoggerFactory.getLogger(DependencyManagementApplier.class);
    private final Project project;
    private final ExclusionResolver exclusionResolver;
    private final DependencyManagementContainer dependencyManagementContainer;
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final DependencyManagementSettings dependencyManagementSettings;

    public DependencyManagementApplier(Project project, DependencyManagementContainer dependencyManagementContainer, DependencyManagementConfigurationContainer configurationContainer, DependencyManagementSettings dependencyManagementSettings, PomResolver pomResolver) {
        this.project = project;
        this.exclusionResolver = new ExclusionResolver(pomResolver);
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.configurationContainer = configurationContainer;
        this.dependencyManagementSettings = dependencyManagementSettings;
    }

    public void execute(final Configuration configuration) {
        logger.info("Applying dependency management to configuration '{}' in project '{}'", (Object)configuration.getName(), (Object)this.project.getName());
        configuration.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                DependencyManagementApplier.this.dependencyManagementContainer.getManagedVersionsForConfiguration(configuration);
            }
        });
        final VersionConfiguringAction versionConfiguringAction = new VersionConfiguringAction(this.project, this.dependencyManagementContainer, configuration);
        configuration.getIncoming().beforeResolve((Action)new ExclusionConfiguringAction(this.dependencyManagementSettings, this.dependencyManagementContainer, this.configurationContainer, configuration, this.exclusionResolver, new DependencyManagementConfigurationContainer.ConfigurationConfigurer(){

            @Override
            public void configure(Configuration configuration) {
                configuration.getResolutionStrategy().eachDependency((Action)versionConfiguringAction);
            }
        }));
        configuration.getResolutionStrategy().eachDependency((Action)versionConfiguringAction);
    }
}

