/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.shadow.retrofit2.converter.gson;

import io.github.gradlenexus.publishplugin.shadow.com.google.gson.Gson;
import io.github.gradlenexus.publishplugin.shadow.com.google.gson.TypeAdapter;
import io.github.gradlenexus.publishplugin.shadow.com.google.gson.stream.JsonWriter;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.MediaType;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.RequestBody;
import io.github.gradlenexus.publishplugin.shadow.okio.Buffer;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.Converter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

final class GsonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.get("application/json; charset=UTF-8");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    GsonRequestBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    @Override
    public RequestBody convert(T value) throws IOException {
        Buffer buffer = new Buffer();
        OutputStreamWriter writer = new OutputStreamWriter(buffer.outputStream(), UTF_8);
        JsonWriter jsonWriter = this.gson.newJsonWriter(writer);
        this.adapter.write(jsonWriter, value);
        jsonWriter.close();
        return RequestBody.create(MEDIA_TYPE, buffer.readByteString());
    }
}

