/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.internal;

import io.freefair.gradle.plugins.lombok.internal.CleanLombokConfig;
import io.freefair.gradle.plugins.lombok.tasks.LombokConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigUtil.class);
    private static final Pattern stopBubblingPattern = Pattern.compile("\\s*config\\.stopBubbling\\s*=\\s*true\\s*", 2);
    private static final Pattern importPattern = Pattern.compile("\\s*import\\s*(.*?)\\s*", 2);

    @Deprecated
    public static Map<File, TaskProvider<LombokConfig>> getLombokConfigTasks(Project project, String sourceSetName, Set<File> srcDirs) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(ConfigUtil.class, (String)"getLombokConfigTasks()").willBeRemovedInGradle9().undocumented()).nagUser();
        HashMap<File, TaskProvider<LombokConfig>> result = new HashMap<File, TaskProvider<LombokConfig>>();
        int i = 1;
        for (File srcDir : srcDirs) {
            int finalI = i;
            String taskName = "generate" + StringGroovyMethods.capitalize((CharSequence)sourceSetName) + "EffectiveLombokConfig" + i;
            TaskProvider genConfigTask = project.getTasks().register(taskName, LombokConfig.class, lombokConfigTask -> {
                lombokConfigTask.setGroup("lombok");
                lombokConfigTask.setDescription("Generate effective Lombok configuration for '" + srcDir + "' of source-set '" + sourceSetName + "'.");
                lombokConfigTask.getPaths().from(new Object[]{srcDir});
                lombokConfigTask.getOutputFile().set(project.getLayout().getBuildDirectory().file("lombok/effective-config/" + sourceSetName + "/lombok-" + finalI + ".config"));
            });
            result.put(srcDir, (TaskProvider<LombokConfig>)genConfigTask);
            ++i;
        }
        return result;
    }

    public static TaskProvider<LombokConfig> getLombokConfigTask(Project project, SourceSet sourceSet) {
        String taskName = sourceSet.getTaskName("generate", "effectiveLombokConfig");
        return project.getTasks().register(taskName, LombokConfig.class, lombokConfigTask -> {
            lombokConfigTask.setGroup("lombok");
            lombokConfigTask.setDescription("Generate effective Lombok configuration for source-set '" + sourceSet.getName() + "'.");
            lombokConfigTask.getPaths().from(new Object[]{sourceSet.getJava().getSourceDirectories()});
            lombokConfigTask.getOutputFile().set(project.getLayout().getBuildDirectory().file("lombok/effective-config/lombok-" + sourceSet.getName() + ".config"));
            lombokConfigTask.doLast("cleanLombokConfig", new CleanLombokConfig());
        });
    }

    public static Provider<Boolean> isDisableConfig(Project project) {
        return project.getProviders().gradleProperty("lombok.disableConfig").orElse(project.getProviders().systemProperty("lombok.disableConfig")).map(propValue -> !"false".equalsIgnoreCase(propValue.trim())).orElse((Object)false);
    }

    @Nullable
    public static Set<File> resolveConfigFilesForPath(File path) throws IOException {
        for (path = path.getAbsoluteFile(); path != null && !path.isDirectory(); path = path.getParentFile()) {
        }
        HashSet<File> result = new HashSet<File>();
        for (File dir = path; dir != null; dir = dir.getParentFile()) {
            File lombokConfigFile = new File(dir, "lombok.config");
            if (!lombokConfigFile.isFile()) continue;
            result.add(lombokConfigFile);
            List<String> lines = Files.readAllLines(lombokConfigFile.toPath());
            for (String s : lines) {
                Matcher matcher = importPattern.matcher(s);
                if (!matcher.matches()) continue;
                log.info("{} imports {}", (Object)lombokConfigFile, (Object)matcher.group(1));
                return null;
            }
            if (!lines.stream().anyMatch(line -> stopBubblingPattern.matcher((CharSequence)line).matches())) continue;
            return result;
        }
        return result;
    }

    @Generated
    private ConfigUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

