/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokJarTask;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;

@NonNullApi
@CacheableTask
public class LombokApiJar
extends LombokJarTask {
    private final FileSystemOperations fileSystemOperations;
    private final ProcessOperations processOperations;

    @Inject
    public LombokApiJar(FileSystemOperations fileSystemOperations, ProcessOperations processOperations) {
        this.fileSystemOperations = fileSystemOperations;
        this.processOperations = processOperations;
        this.getArchiveAppendix().convention((Object)"api");
    }

    @TaskAction
    public void copy() {
        this.fileSystemOperations.delete(spec -> spec.delete(new Object[]{this.getArchiveFile()}).setFollowSymlinks(false));
        File destinationDir = (File)this.getDestinationDirectory().getAsFile().get();
        this.processOperations.javaexec(apiJar -> {
            apiJar.setClasspath((FileCollection)this.getLombokClasspath());
            apiJar.getMainClass().set((Object)"lombok.launch.Main");
            apiJar.args(new Object[]{"publicApi", destinationDir.getAbsolutePath()});
        });
        new File(destinationDir, "lombok-api.jar").renameTo(((RegularFile)this.getArchiveFile().get()).getAsFile());
    }
}

