/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import io.freefair.gradle.plugins.lombok.tasks.LombokTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;

@UntrackedTask(because="lombok config bubbling traverses the file system")
public class LombokConfig
extends DefaultTask
implements LombokTask {
    @Classpath
    private final ConfigurableFileCollection lombokClasspath = this.getProject().files(new Object[0]);
    @Input
    private final Property<Boolean> generate = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    @Input
    private final Property<Boolean> verbose = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    @Input
    private final Property<Boolean> notMentioned = this.getProject().getObjects().property(Boolean.class).convention((Object)false);
    @Input
    @Optional
    private final ListProperty<String> keys = this.getProject().getObjects().listProperty(String.class);
    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    private final ConfigurableFileCollection paths = this.getProject().getObjects().fileCollection();
    @OutputFile
    private final RegularFileProperty outputFile = this.getProject().getObjects().fileProperty();

    public LombokConfig() {
        this.getOutputs().upToDateWhen(t -> ((LombokConfig)t).getPaths().isEmpty());
    }

    @TaskAction
    public void exec() throws IOException {
        this.getProject().delete(new Object[]{this.outputFile});
        List actualPaths = this.paths.getFiles().stream().filter(File::exists).collect(Collectors.toList());
        if (actualPaths.isEmpty() && !((Boolean)this.generate.get()).booleanValue()) {
            ((RegularFile)this.outputFile.get()).getAsFile().createNewFile();
            return;
        }
        try (FileOutputStream out = new FileOutputStream((File)this.outputFile.getAsFile().get());){
            this.getProject().javaexec(config -> {
                config.setClasspath((FileCollection)this.getLombokClasspath());
                config.getMainClass().set((Object)"lombok.launch.Main");
                config.args(new Object[]{"config"});
                config.setStandardOutput(out);
                if (((Boolean)this.generate.getOrElse((Object)false)).booleanValue()) {
                    config.args(new Object[]{"--generate"});
                }
                if (((Boolean)this.verbose.getOrElse((Object)false)).booleanValue()) {
                    config.args(new Object[]{"--verbose"});
                }
                if (((Boolean)this.notMentioned.getOrElse((Object)false)).booleanValue()) {
                    config.args(new Object[]{"--not-mentioned"});
                }
                for (String key : (List)this.keys.getOrElse(Collections.emptyList())) {
                    config.args(new Object[]{"--key=" + key.trim()});
                }
                for (File path : actualPaths) {
                    config.args(new Object[]{path});
                }
            });
        }
    }

    @Override
    @Generated
    public ConfigurableFileCollection getLombokClasspath() {
        return this.lombokClasspath;
    }

    @Generated
    public Property<Boolean> getGenerate() {
        return this.generate;
    }

    @Generated
    public Property<Boolean> getVerbose() {
        return this.verbose;
    }

    @Generated
    public Property<Boolean> getNotMentioned() {
        return this.notMentioned;
    }

    @Generated
    public ListProperty<String> getKeys() {
        return this.keys;
    }

    @Generated
    public ConfigurableFileCollection getPaths() {
        return this.paths;
    }

    @Generated
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }
}

