/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class CheckLombokConfig
extends DefaultTask {
    @Input
    private final String sourceSet;
    @Input
    @Optional
    private final MapProperty<File, File> configs = this.getProject().getObjects().mapProperty(File.class, File.class);
    @Input
    @Optional
    private final ListProperty<String> expectedConfigs = this.getProject().getObjects().listProperty(String.class);

    @Inject
    public CheckLombokConfig(SourceSet sourceSet) {
        this.sourceSet = sourceSet.getName();
        this.setGroup("verification");
        this.setDescription("Check lombok configuration for source set " + this.getSourceSet());
    }

    @TaskAction
    public void check() throws IOException {
        for (Map.Entry entry : ((Map)this.configs.getOrElse(Collections.emptyMap())).entrySet()) {
            File dir = (File)entry.getKey();
            if (!dir.exists()) continue;
            String config = String.join((CharSequence)"\n", Files.readAllLines(((File)entry.getValue()).toPath()));
            for (String expected : (List)this.expectedConfigs.getOrElse(Collections.emptyList())) {
                if (config.contains(expected)) continue;
                this.getLogger().warn("'{}' is not configured for '{}' of the {} source-set", new Object[]{expected, dir, this.sourceSet});
            }
        }
    }

    @Generated
    public String getSourceSet() {
        return this.sourceSet;
    }

    @Generated
    public MapProperty<File, File> getConfigs() {
        return this.configs;
    }

    @Generated
    public ListProperty<String> getExpectedConfigs() {
        return this.expectedConfigs;
    }
}

